/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.client.proxy.impl;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.Response;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.core.client.proxy.AbstractRpcProxy;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkRpcProxy<T>
extends AbstractRpcProxy<T>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(JdkRpcProxy.class);

    @Override
    public T doCreateProxy() {
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.interfaceClass, Serializable.class}, (InvocationHandler)this);
        return (T)proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Response response;
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            if ("toString".equals(methodName)) {
                return super.toString();
            }
            if ("hashCode".equals(methodName)) {
                return super.hashCode();
            }
        } else if (parameterTypes.length == 1 && "equals".equals(methodName)) {
            return proxy.equals(args[0]);
        }
        Request request = this.warpRequest(proxy, method, args);
        this.startRegistryIfNecessary(this.rpcConfiguration.getRegistryUrl());
        RemotingClient rpcClient = this.loadBalance(request);
        Object resObj = this.retryRequest(rpcClient, request);
        if (resObj instanceof Response) {
            response = (Response)resObj;
        } else {
            response = new Response(request.getId());
            response.setResult(resObj);
            response.setStatus((byte)20);
        }
        if (20 == response.getStatus()) {
            return response.getResult();
        }
        throw new RpcException("rpc\u8bf7\u6c42\u9519\u8bef \uff0c status=" + response.getStatus() + "msg=" + response.getErrorMessage());
    }
}

