/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.client.proxy;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.remoting.api.RemotingConfiguration;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.RequestResponseRemotingDataProcessor;
import cloud.tianai.remoting.api.RpcInvocation;
import cloud.tianai.remoting.api.exception.RpcRemotingException;
import cloud.tianai.rpc.common.CommonConstant;
import cloud.tianai.rpc.common.KeyValue;
import cloud.tianai.rpc.common.Result;
import cloud.tianai.rpc.common.RpcClientConfiguration;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.core.client.proxy.RpcProxy;
import cloud.tianai.rpc.core.factory.CodecFactory;
import cloud.tianai.rpc.core.factory.LoadBalanceFactory;
import cloud.tianai.rpc.core.factory.RemotingClientFactory;
import cloud.tianai.rpc.core.holder.RegistryHolder;
import cloud.tianai.rpc.core.holder.RpcClientHolder;
import cloud.tianai.rpc.core.loadbalance.LoadBalance;
import cloud.tianai.rpc.core.template.RpcClientTemplate;
import cloud.tianai.rpc.core.util.RegistryUtils;
import cloud.tianai.rpc.registory.api.NotifyListener;
import cloud.tianai.rpc.registory.api.Registry;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataDecoder;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataEncoder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcProxy<T>
implements RpcProxy<T>,
NotifyListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractRpcProxy.class);
    protected Class<T> interfaceClass;
    protected Registry registry;
    protected URL url;
    protected List<URL> subscribeUrls = Collections.emptyList();
    protected final Object lock = new Object();
    protected Integer requestTimeout;
    protected LoadBalance loadBalance;
    protected RpcClientConfiguration rpcConfiguration;
    public static final int DEFAULT_REQUEST_RETRY = 3;
    protected int retry = 3;
    protected RpcClientTemplate rpcClientTemplate;

    protected void lookAndSubscribeUrl(URL url) {
        Result lookup = this.registry.lookup(url);
        if (!lookup.isSuccess()) {
            throw new RpcException("\u65e0\u6cd5\u4eceregistry\u4e2d\u62c9\u53d6\u914d\u7f6e\u6d88\u606f, e=" + lookup.getMsg() + ", code=" + lookup.getCode());
        }
        List urls = (List)lookup.getData();
        if (CollectionUtils.isEmpty((Collection)urls)) {
            throw new RpcException("\u65e0\u6cd5\u8bfb\u53d6\u5230\u5bf9\u5e94\u63a5\u53e3\u7684\u6ce8\u518c\u5730\u5740, " + url);
        }
        this.subscribeUrls = urls;
        log.info("TIAN-RPC REGISTRY {}\u62c9\u53d6\u5230\u6d88\u606f:{}", (Object)this.registry.getProtocol(), (Object)urls);
        this.registry.subscribe(url, (NotifyListener)this);
    }

    @Override
    public T createProxy(Class<T> interfaceClass, RpcClientConfiguration conf, boolean lazyLoadRegistry, boolean lazyStartRpcClient) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("\u521b\u5efarpc\u4ee3\u7406\u9519\u8bef\uff0cclass\u5fc5\u987b\u662f\u63a5\u53e3");
        }
        this.rpcConfiguration = conf;
        this.interfaceClass = interfaceClass;
        this.url = new URL("tianai-rpc", "127.0.0.1", 0, interfaceClass.getName());
        if (!lazyLoadRegistry) {
            this.registry = this.startRegistry(conf.getRegistryUrl());
            if (!lazyStartRpcClient) {
                List<URL> urls = this.lookUpOfThrow();
                for (URL url : urls) {
                    this.getRpcClient(url);
                }
            }
        }
        String loadBalanceName = (String)conf.getOrDefault((Object)conf.getLoadBalance(), (Object)"roundrobin");
        this.loadBalance = LoadBalanceFactory.getLoadBalance(loadBalanceName);
        if (this.loadBalance == null) {
            throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8f6e\u8be2\u7b56\u7565, loadBalanceName=" + loadBalanceName);
        }
        if (this.url != null && this.registry != null) {
            this.lookAndSubscribeUrl(this.url);
        }
        this.requestTimeout = conf.getRequestTimeout();
        this.rpcClientTemplate = new RpcClientTemplate(this.requestTimeout, this.retry, this.lock);
        return this.doCreateProxy();
    }

    protected abstract T doCreateProxy();

    protected Registry startRegistry(URL registryUrl) {
        Registry registry = RegistryHolder.computeIfAbsent(registryUrl, RegistryUtils::createAndStart);
        registry.subscribe(() -> this.lookAndSubscribeUrl(this.url));
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRegistryIfNecessary(URL registryUrl) {
        if (this.registry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.registry == null) {
                    this.registry = this.startRegistry(registryUrl);
                }
            }
        }
    }

    public void notify(List<URL> urls) {
        log.debug("[registry] \u8ba2\u9605\u5230\u6d88\u606f: {}", urls);
        this.subscribeUrls = urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemotingClient loadBalance(Request request) {
        Object object = this.lock;
        synchronized (object) {
            List<URL> urls = this.lookUpOfThrow();
            List<RemotingClient> rpcClients = this.getRpcClients(urls);
            RemotingClient rpcClient = this.loadBalance.select(rpcClients, this.url, request);
            return rpcClient;
        }
    }

    private List<RemotingClient> getRpcClients(List<URL> urls) {
        ArrayList<RemotingClient> result = new ArrayList<RemotingClient>(urls.size());
        for (URL u : urls) {
            result.add(this.getRpcClient(u));
        }
        return result;
    }

    private RemotingClient getRpcClient(URL url) {
        return RpcClientHolder.computeIfAbsent(url.getProtocol(), url.getAddress(), (p, a) -> {
            String host = url.getHost();
            if (StringUtils.isBlank((CharSequence)host)) {
                throw new RpcException("\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25\uff0c\u5fc5\u987b\u6307\u5b9ahost");
            }
            Integer port = url.getPort();
            int workThreads = this.rpcConfiguration.getWorkerThread();
            String codecProtocol = (String)this.rpcConfiguration.getOrDefault((Object)this.rpcConfiguration.getCodec(), (Object)"hessian2");
            KeyValue<RemotingDataEncoder, RemotingDataDecoder> codec = CodecFactory.getCodec(codecProtocol);
            if (codec == null || !codec.isNotEmpty()) {
                throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684codec\uff0c protocol=" + codecProtocol);
            }
            Integer timeout = (Integer)this.rpcConfiguration.getOrDefault((Object)this.rpcConfiguration.getTimeout(), (Object)CommonConstant.DEFAULT_TIMEOUT);
            RemotingConfiguration conf = new RemotingConfiguration();
            conf.setHost(host);
            conf.setPort(port);
            conf.setWorkerThreads(Integer.valueOf(workThreads));
            conf.setEncoder((RemotingDataEncoder)codec.getKey());
            conf.setDecoder((RemotingDataDecoder)codec.getValue());
            conf.setConnectTimeout(timeout);
            conf.setRemotingDataProcessor((RemotingDataProcessor)new RequestResponseRemotingDataProcessor((RpcInvocation)new HeartbeatRpcInvocation()));
            String client = this.rpcConfiguration.getProtocol();
            RemotingClient c = RemotingClientFactory.create(client);
            if (c == null) {
                throw new RpcRemotingException("\u65e0\u6cd5\u521b\u5efa\u5bf9\u5e94\u7684 \u8fdc\u7a0b\u5ba2\u6237\u7aef \uff0c client=" + client);
            }
            c.start(conf);
            return c;
        });
    }

    protected Request warpRequest(Object proxy, Method method, Object[] args) {
        Request request = new Request();
        request.setVersion("v1").setRequestParam(args).setMethodName(method.getName()).setInterfaceType(this.interfaceClass).setReturnType(method.getReturnType()).setHeartbeat(false);
        return request;
    }

    protected Object retryRequest(RemotingClient rpcClient, Request request) throws TimeoutException {
        return this.rpcClientTemplate.retryRequest(rpcClient, request, this::loadBalance);
    }

    private List<URL> lookUpOfThrow() {
        if (CollectionUtils.isEmpty(this.subscribeUrls)) {
            this.lookAndSubscribeUrl(this.url);
        }
        if (CollectionUtils.isEmpty(this.subscribeUrls)) {
            throw new RpcException("\u6ce8\u518c\u5668\u4e2d\u65e0\u6cd5\u8bfb\u53d6\u5230\u8be5URL [" + this.url + "] \u5bf9\u5e94\u7684\u6ce8\u518c\u5730\u5740");
        }
        return this.subscribeUrls;
    }

    public String toString() {
        return "tianai-rpc-proxy{interfaceClass=" + this.interfaceClass + ", registry=" + this.registry + ", url=" + this.url + ", requestTimeout=" + this.requestTimeout + ", prop=" + this.rpcConfiguration + '}';
    }

    public static class HeartbeatRpcInvocation
    implements RpcInvocation {
        public Object invoke(Request request) {
            if (request.isHeartbeat()) {
                return "heartbeat success";
            }
            return null;
        }
    }
}

