/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.common.util;

import java.security.CodeSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcVersion {
    private static final Logger log = LoggerFactory.getLogger(RpcVersion.class);
    private static final String VERSION = RpcVersion.getVersion(RpcVersion.class, "");

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        CodeSource codeSource;
        Package pkg = RpcVersion.class.getPackage();
        String version = null;
        if (pkg != null) {
            version = pkg.getImplementationVersion();
            if (StringUtils.isNotEmpty((CharSequence)version)) {
                return version;
            }
            version = pkg.getSpecificationVersion();
            if (StringUtils.isNotEmpty((CharSequence)version)) {
                return version;
            }
        }
        if ((codeSource = cls.getProtectionDomain().getCodeSource()) == null) {
            log.info("No codeSource for class " + cls.getName() + " when getVersion, use default version " + defaultVersion);
            return defaultVersion;
        }
        String file = codeSource.getLocation().getFile();
        if (!StringUtils.isEmpty((CharSequence)file) && file.endsWith(".jar")) {
            version = RpcVersion.getFromFile(file);
        }
        return StringUtils.isEmpty((CharSequence)version) ? defaultVersion : version;
    }

    private static String getFromFile(String file) {
        int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
        if (i >= 0) {
            file = file.substring(i + 1);
        }
        if ((i = file.indexOf("-")) >= 0) {
            file = file.substring(i + 1);
        }
        while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
            file = file.substring(i + 1);
        }
        return file;
    }

    public static void main(String[] args) {
        System.out.println(RpcVersion.getVersion());
    }
}

