/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.common.extension;

import cloud.tianai.rpc.common.extension.SPI;
import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.common.util.ExceptionUtils;
import cloud.tianai.rpc.common.util.Holder;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String RPC_DIRECTORY = "META-INF/tianai-rpc/";
    private static final String SERVICES_DIRECTORY = "META-INF/services/";
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");
    private static final ConcurrentMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();
    private Map<String, IllegalStateException> exceptions = new ConcurrentHashMap<String, IllegalStateException>();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final ConcurrentMap<Class<?>, String> cachedNames = new ConcurrentHashMap();
    private final Holder<Map<String, Class<? extends T>>> cachedClasses = new Holder();
    private final Class<?> type;
    private String cachedDefaultName;

    private ExtensionLoader(Class<?> type) {
        this.type = type;
    }

    public String getExtensionName(Class<?> extensionClass) {
        this.getExtensionClasses();
        return (String)this.cachedNames.get(extensionClass);
    }

    public boolean hasExtension(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Class<T> c = this.getExtensionClass(name);
        return c != null;
    }

    public Class<? extends T> getExtensionClass(String name) {
        if (this.type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Extension name == null");
        }
        return this.getExtensionClasses().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        if (Boolean.TRUE.toString().equals(name)) {
            return this.getDefaultExtension();
        }
        Holder<Object> holder = this.getOrCreateHolder(name);
        Object instance = holder.get();
        if (instance == null) {
            Holder<Object> holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name, true);
                    holder.set(instance);
                }
            }
        }
        return (T)instance;
    }

    public T createExtension(String name, boolean cache) {
        Class<T> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw this.findException(name);
        }
        try {
            Object instance;
            if (cache) {
                instance = EXTENSION_INSTANCES.get(clazz);
                if (instance == null) {
                    EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                    instance = EXTENSION_INSTANCES.get(clazz);
                }
            } else {
                instance = clazz.newInstance();
            }
            this.initExtension(instance);
            return instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance (name: " + name + ", class: " + this.type + ") couldn't be instantiated: " + t.getMessage(), t);
        }
    }

    public IllegalStateException findException(String name) {
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(name.toLowerCase())) continue;
            return entry.getValue();
        }
        StringBuilder buf = new StringBuilder("No such extension " + this.type.getName() + " by name " + name);
        int i = 1;
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (i == 1) {
                buf.append(", possible causes: ");
            }
            buf.append("\r\n(");
            buf.append(i++);
            buf.append(") ");
            buf.append(entry.getKey());
            buf.append(":\r\n");
            buf.append(ExceptionUtils.toString(entry.getValue()));
        }
        return new IllegalStateException(buf.toString());
    }

    public T getDefaultExtension() {
        this.getExtensionClasses();
        if (StringUtils.isBlank((CharSequence)this.cachedDefaultName) || Boolean.TRUE.toString().equals(this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<? extends T>> getExtensionClasses() {
        Map<String, Class<Object>> classes = this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<? extends T>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.get();
                if (classes == null) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    public void addExtension(String name, Class<?> clazz) {
        this.getExtensionClasses();
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Input type " + clazz + " doesn't implement the Extension " + this.type);
        }
        if (clazz.isInterface()) {
            throw new IllegalStateException("Input type " + clazz + " can't be interface!");
        }
        Class<?> transformClass = clazz;
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalStateException("Extension name is blank (Extension " + this.type + ")!");
        }
        if (this.cachedClasses.get().containsKey(name)) {
            throw new IllegalStateException("Extension name " + name + " already exists (Extension " + this.type + ")!");
        }
        this.cachedNames.put(clazz, name);
        this.cachedClasses.get().put(name, transformClass);
    }

    private void initExtension(T instance) {
    }

    private Holder<Object> getOrCreateHolder(String name) {
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        return holder;
    }

    private Map<String, Class<? extends T>> loadExtensionClasses() {
        this.cacheDefaultExtensionName();
        HashMap<String, Class<? extends T>> extensionClasses = new HashMap<String, Class<? extends T>>(16);
        this.loadDirectory(extensionClasses, RPC_DIRECTORY, this.type.getName(), true);
        this.loadDirectory(extensionClasses, SERVICES_DIRECTORY, this.type.getName(), true);
        return extensionClasses;
    }

    private void loadDirectory(Map<String, Class<? extends T>> extensionClasses, String dir, String type, boolean extensionLoaderClassLoaderFirst) {
        String fileName = dir + type;
        try {
            Enumeration<URL> urls = null;
            ClassLoader classLoader = ExtensionLoader.findClassLoader();
            if (extensionLoaderClassLoaderFirst) {
                ClassLoader extensionLoaderClassLoader = ExtensionLoader.class.getClassLoader();
                if (ClassLoader.getSystemClassLoader() != extensionLoaderClassLoader) {
                    urls = extensionLoaderClassLoader.getResources(fileName);
                }
            }
            if (urls == null || !urls.hasMoreElements()) {
                urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            }
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL resourceUrl = urls.nextElement();
                    this.loadResource(extensionClasses, classLoader, resourceUrl);
                }
            }
        }
        catch (Throwable t) {
            log.error("Exception occurred when loading extension class (interface: " + type + ", description file: " + fileName + ").", t);
        }
    }

    private void loadResource(Map<String, Class<? extends T>> extensionClasses, ClassLoader classLoader, URL resourceUrl) {
        try {
            InputStream inputStream = resourceUrl.openStream();
            Properties prop = new Properties();
            prop.load(inputStream);
            prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                String name = String.valueOf(key);
                String valueStr = String.valueOf(value);
                try {
                    Class<?> clazz = Class.forName(valueStr, true, classLoader);
                    if (!this.type.isAssignableFrom(clazz)) {
                        throw new IllegalStateException("Error occurred when loading extension class (interface: " + this.type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + " is not subtype of interface.");
                    }
                    Class<?> finalClass = clazz;
                    Object[] names = NAME_SEPARATOR.split(name);
                    if (ArrayUtils.isNotEmpty((Object[])names)) {
                        for (Object n : names) {
                            this.cacheName(clazz, (String)n);
                            this.saveInExtensionClass(extensionClasses, finalClass, (String)n);
                        }
                    }
                }
                catch (Throwable t) {
                    IllegalStateException e = new IllegalStateException("Failed to load extension class (interface: " + this.type + ", class line: " + valueStr + ") in " + resourceUrl + ", cause: " + t.getMessage(), t);
                    this.exceptions.put(valueStr, e);
                }
            }));
        }
        catch (Throwable t) {
            log.error("Exception occurred when loading extension class (interface: " + this.type + ", class file: " + resourceUrl + ") in " + resourceUrl, t);
        }
    }

    private void saveInExtensionClass(Map<String, Class<? extends T>> extensionClasses, Class<? extends T> clazz, String name) {
        Class<T> c = extensionClasses.get(name);
        if (c == null) {
            extensionClasses.put(name, clazz);
        } else if (c != clazz) {
            String duplicateMsg = "Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName();
            log.error(duplicateMsg);
            throw new IllegalStateException(duplicateMsg);
        }
    }

    private void cacheName(Class<?> clazz, String name) {
        if (!this.cachedNames.containsKey(clazz)) {
            this.cachedNames.put(clazz, name);
        }
    }

    private void cacheDefaultExtensionName() {
        SPI defaultAnnotation = this.type.getAnnotation(SPI.class);
        if (defaultAnnotation == null) {
            return;
        }
        String value = defaultAnnotation.value();
        if ((value = value.trim()).length() > 0) {
            Object[] names = NAME_SEPARATOR.split(value);
            if (names.length > 1) {
                throw new IllegalStateException("More than 1 default extension name on extension " + this.type.getName() + ": " + Arrays.toString(names));
            }
            if (names.length == 1) {
                this.cachedDefaultName = names[0];
            }
        }
    }

    private static <T> boolean withExtensionAnnotation(Class<T> type) {
        return type.isAnnotationPresent(SPI.class);
    }

    private static ClassLoader findClassLoader() {
        return ClassUtils.getClassLoader(ExtensionLoader.class);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an interface!");
        }
        if (!ExtensionLoader.withExtensionAnnotation(type)) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an extension, because it is NOT annotated with @" + SPI.class.getSimpleName() + "!");
        }
        ExtensionLoader loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            EXTENSION_LOADERS.putIfAbsent(type, new ExtensionLoader<T>(type));
            loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        }
        return loader;
    }

    public static void resetExtensionLoader(Class type) {
        ExtensionLoader loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        if (loader != null) {
            Map classes = loader.getExtensionClasses();
            for (Map.Entry entry : classes.entrySet()) {
                EXTENSION_INSTANCES.remove(entry.getValue());
            }
            classes.clear();
            EXTENSION_LOADERS.remove(type);
        }
    }
}

