/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.common;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ParametersWrapper {
    public static final Pattern COMMA_SPLIT_PATTERN = Pattern.compile("\\s*[,]+\\s*");
    private Map<String, String> parameters;

    public ParametersWrapper(Map<String, String> param) {
        this.parameters = new HashMap<String, String>(param);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : value;
    }

    public String[] getParameter(String key, String[] defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : COMMA_SPLIT_PATTERN.split(value);
    }

    public Integer getParameter(String key, int defaultValue) {
        String value = this.getParameter(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public ParametersWrapper addParameter(String key, Enum<?> value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public ParametersWrapper addParameter(String key, Number value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public ParametersWrapper addParameter(String key, CharSequence value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public ParametersWrapper addParameter(String key, boolean value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public ParametersWrapper addParameter(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) {
            return this;
        }
        if (value.equals(this.getParameters().get(key))) {
            return this;
        }
        this.parameters.put(key, value);
        return this;
    }

    public ParametersWrapper addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) {
            return this;
        }
        if (this.hasParameter(key)) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(key, value);
        return this;
    }

    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return value != null && value.length() > 0;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

