/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ClassUtils {
    public static <T> T createObject(Class<? extends T> clazz, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (clazz.isInterface()) {
            throw new InstantiationException("\u8be5class\u662f\u4e2a\u63a5\u53e3\uff0c\u4e0d\u53ef\u5b9e\u4f8b\u5316");
        }
        Class<?>[] types = ClassUtils.getType(args);
        Constructor<T> constructor = clazz.getConstructor(types);
        T res = constructor.newInstance(args);
        return res;
    }

    public static Class<?>[] getType(Object[] params) {
        if (params == null || params.length < 1) {
            return new Class[0];
        }
        Class[] classArr = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> clazz;
            classArr[i] = clazz = params[i].getClass();
        }
        return classArr;
    }

    public static Class<?> forName(String classStr, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(classStr);
        return clazz;
    }

    public static Class<?> forName(String classStr) throws ClassNotFoundException {
        return ClassUtils.forName(classStr, Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classLoader;
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = ClassUtils.getClassLoader();
        if (cl == null && (cl = clazz.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static ClassLoader getCallerClassLoader(Class<?> caller) {
        return caller.getClassLoader();
    }
}

