/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.common.sort;

import cloud.tianai.rpc.common.sort.Ordered;
import cloud.tianai.rpc.common.util.ObjectUtils;
import java.util.Comparator;

public class OrderComparator
implements Comparator<Object> {
    public static final OrderComparator INSTANCE = new OrderComparator();

    @Override
    public int compare(Object o1, Object o2) {
        return this.doCompare(o1, o2, null);
    }

    private int doCompare(Object o1, Object o2, OrderSourceProvider sourceProvider) {
        int i1 = this.getOrder(o1, sourceProvider);
        int i2 = this.getOrder(o2, sourceProvider);
        return Integer.compare(i1, i2);
    }

    private int getOrder(Object obj, OrderSourceProvider sourceProvider) {
        Object orderSource;
        Integer order = null;
        if (obj != null && sourceProvider != null && (orderSource = sourceProvider.getOrderSource(obj)) != null) {
            if (orderSource.getClass().isArray()) {
                Object source;
                Object[] sources;
                Object[] objectArray = sources = ObjectUtils.toObjectArray(orderSource);
                int n = objectArray.length;
                for (int i = 0; i < n && (order = this.findOrder(source = objectArray[i])) == null; ++i) {
                }
            } else {
                order = this.findOrder(orderSource);
            }
        }
        return order != null ? order.intValue() : this.getOrder(obj);
    }

    protected int getOrder(Object obj) {
        Integer order;
        if (obj != null && (order = this.findOrder(obj)) != null) {
            return order;
        }
        return 0;
    }

    protected Integer findOrder(Object obj) {
        return obj instanceof Ordered ? Integer.valueOf(((Ordered)obj).getOrder()) : null;
    }

    @FunctionalInterface
    public static interface OrderSourceProvider {
        public Object getOrderSource(Object var1);
    }
}

