/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.common;

import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Consumer;

public class Result<T> {
    public static final Integer SUCCESS_CODE = 200;
    public static final Integer ERROR_CODE = 500;
    private Integer code;
    private String msg;
    private T data;

    public static <T> Result<T> ofSuccess(T data) {
        return new Result<T>(SUCCESS_CODE, null, data);
    }

    public static <T> Result<T> ofMessage(Integer code, String msg) {
        return new Result<Object>(code, msg, null);
    }

    public static <T> Result<T> ofError(String msg) {
        return new Result<Object>(ERROR_CODE, msg, null);
    }

    public boolean isSuccess() {
        return SUCCESS_CODE.equals(this.code);
    }

    public boolean compare(Integer code) {
        return Objects.equals(this.code, code);
    }

    public Result<T> compare(Integer code, Consumer<T> consumer) {
        if (this.compare(code)) {
            consumer.accept(this.data);
        }
        return this;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public Result() {
    }

    @ConstructorProperties(value={"code", "msg", "data"})
    public Result(Integer code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }
}

