/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.common;

import cloud.tianai.rpc.common.util.CollectionUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class URL
implements Serializable {
    public static final String METHODS_KEY = "methods";
    public static final String INTERFACE_KEY = "interface";
    public static final String PATH_SEPARATOR = "/";
    public static final String ANY_VALUE = "*";
    public static final Pattern COMMA_SPLIT_PATTERN = Pattern.compile("\\s*[,]+\\s*");
    private String protocol;
    private String username;
    private String password;
    private String host;
    private int port;
    private String path;
    private Map<String, String> parameters;
    private Map<String, Map<String, String>> methodParameters;
    private volatile transient Map<String, Number> numbers;
    private volatile transient Map<String, Map<String, Number>> methodNumbers;
    private volatile transient Map<String, URL> urls;
    private volatile transient String ip;
    private volatile transient String full;
    private volatile transient String identity;
    private volatile transient String parameter;
    private volatile transient String string;
    private transient String serviceKey;

    public URL() {
        this.protocol = null;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = 0;
        this.path = null;
        this.parameters = new ConcurrentHashMap<String, String>(16);
        this.methodParameters = new ConcurrentHashMap<String, Map<String, String>>(16);
    }

    public URL(String protocol, String host, int port) {
        this(protocol, null, null, host, port, null, (Map<String, String>)null);
    }

    public URL(String protocol, String host, int port, String[] pairs) {
        this(protocol, null, null, host, port, null, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public URL(String protocol, String host, int port, String path) {
        this(protocol, null, null, host, port, path, (Map<String, String>)null);
    }

    public URL(String protocol, String host, int port, String path, String ... pairs) {
        this(protocol, null, null, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public URL(String protocol, String username, String password, String host, int port, String path) {
        this(protocol, username, password, host, port, path, (Map<String, String>)null);
    }

    public URL(String protocol, String username, String password, String host, int port, String path, String ... pairs) {
        this(protocol, username, password, host, port, path, CollectionUtils.toStringMap(pairs));
    }

    public URL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, username, password, host, port, path, parameters, URL.toMethodParameters(parameters));
    }

    public URL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters, Map<String, Map<String, String>> methodParameters) {
        if (StringUtils.isEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("Invalid url, password without username!");
        }
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.host = host;
        int n = this.port = port < 0 ? 0 : port;
        while (path != null && path.startsWith(PATH_SEPARATOR)) {
            path = path.substring(1);
        }
        this.path = path;
        parameters = parameters == null ? new HashMap<String, String>() : new HashMap<String, String>(parameters);
        this.parameters = Collections.unmodifiableMap(parameters);
        this.methodParameters = Collections.unmodifiableMap(methodParameters);
    }

    public static URL valueOf(String url) {
        if (url == null || (url = url.trim()).length() == 0) {
            throw new IllegalArgumentException("url == null");
        }
        String protocol = null;
        String username = null;
        String password = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = null;
        int i = url.indexOf("?");
        if (i >= 0) {
            String[] parts = url.substring(i + 1).split("&");
            parameters = new HashMap<String, String>();
            for (String part : parts) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    parameters.put(part.substring(0, j), part.substring(j + 1));
                    continue;
                }
                parameters.put(part, part);
            }
            url = url.substring(0, i);
        }
        if ((i = url.indexOf("://")) >= 0) {
            if (i == 0) {
                throw new IllegalStateException("url missing protocol: \"" + url + "\"");
            }
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else {
            i = url.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + url + "\"");
                }
                protocol = url.substring(0, i);
                url = url.substring(i + 1);
            }
        }
        i = url.indexOf(PATH_SEPARATOR);
        if (i >= 0) {
            path = url.substring(i + 1);
            url = url.substring(0, i);
        }
        if ((i = url.lastIndexOf("@")) >= 0) {
            username = url.substring(0, i);
            int j = username.indexOf(":");
            if (j >= 0) {
                password = username.substring(j + 1);
                username = username.substring(0, j);
            }
            url = url.substring(i + 1);
        }
        if ((i = url.lastIndexOf(":")) >= 0 && i < url.length() - 1 && url.lastIndexOf("%") <= i) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            host = url;
        }
        return new URL(protocol, username, password, host, port, path, parameters);
    }

    public static Map<String, Map<String, String>> toMethodParameters(Map<String, String> parameters) {
        HashMap<String, Map<String, String>> methodParameters;
        block5: {
            methodParameters = new HashMap<String, Map<String, String>>();
            if (parameters == null) break block5;
            String methodsString = parameters.get(METHODS_KEY);
            if (StringUtils.isNotEmpty((CharSequence)methodsString)) {
                String[] methods = methodsString.split(",");
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    String key = entry.getKey();
                    for (String method : methods) {
                        String methodPrefix = method + ".";
                        if (!key.startsWith(methodPrefix)) continue;
                        String realKey = key.substring(methodPrefix.length());
                        URL.putMethodParameter(method, realKey, entry.getValue(), methodParameters);
                    }
                }
            } else {
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    String key = entry.getKey();
                    int methodSeparator = key.indexOf(".");
                    if (methodSeparator <= 0) continue;
                    String method = key.substring(0, methodSeparator);
                    String realKey = key.substring(methodSeparator + 1);
                    URL.putMethodParameter(method, realKey, entry.getValue(), methodParameters);
                }
            }
        }
        return methodParameters;
    }

    public static void putMethodParameter(String method, String key, String value, Map<String, Map<String, String>> methodParameters) {
        Map subParameter = methodParameters.computeIfAbsent(method, k -> new HashMap());
        subParameter.put(key, value);
    }

    public static void main(String[] args) {
        URL url = URL.valueOf("dubbo://127.0.0.1:20880/com.xxx.XxxService?version=1.0.0&group=test");
        String urlStr = url.toString();
        System.out.println(url);
        System.out.println(urlStr);
    }

    public String getAddress() {
        return this.port <= 0 ? this.host : this.host + ":" + this.port;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : value;
    }

    public String[] getParameter(String key, String[] defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : COMMA_SPLIT_PATTERN.split(value);
    }

    public String getServiceInterface() {
        return this.getParameter(INTERFACE_KEY, this.path);
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        this.string = this.buildString(false, true, new String[0]);
        return this.string;
    }

    private String buildString(boolean appendUser, boolean appendParameter, String ... parameters) {
        return this.buildString(appendUser, appendParameter, false, false, parameters);
    }

    private String buildString(boolean appendUser, boolean appendParameter, boolean useIP, boolean useService, String ... parameters) {
        String path;
        String host;
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.protocol)) {
            buf.append(this.protocol);
            buf.append("://");
        }
        if (appendUser && StringUtils.isNotEmpty((CharSequence)this.username)) {
            buf.append(this.username);
            if (StringUtils.isNotEmpty((CharSequence)this.password)) {
                buf.append(":");
                buf.append(this.password);
            }
            buf.append("@");
        }
        if (StringUtils.isNotEmpty((CharSequence)(host = useIP ? this.getIp() : this.getHost()))) {
            buf.append(host);
            if (this.port > 0) {
                buf.append(":");
                buf.append(this.port);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(path = useService ? this.getServiceKey() : this.getPath()))) {
            buf.append(PATH_SEPARATOR);
            buf.append(path);
        }
        if (appendParameter) {
            this.buildParameters(buf, true, parameters);
        }
        return buf.toString();
    }

    public String toFullString() {
        if (this.full != null) {
            return this.full;
        }
        this.full = this.buildString(true, true, new String[0]);
        return this.full;
    }

    private void buildParameters(StringBuilder buf, boolean concat, String[] parameters) {
        if (CollectionUtils.isNotEmptyMap(this.getParameters())) {
            List<String> includes = ArrayUtils.isEmpty((Object[])parameters) ? null : Arrays.asList(parameters);
            boolean first = true;
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.getParameters()).entrySet()) {
                if (!StringUtils.isNotEmpty((CharSequence)entry.getKey()) || includes != null && !includes.contains(entry.getKey())) continue;
                if (first) {
                    if (concat) {
                        buf.append("?");
                    }
                    first = false;
                } else {
                    buf.append("&");
                }
                buf.append(entry.getKey());
                buf.append("=");
                buf.append(entry.getValue() == null ? "" : entry.getValue().trim());
            }
        }
    }

    public static String encode(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decode(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Integer getParameter(String key, int defaultValue) {
        String value = this.getParameter(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, Map<String, String>> getMethodParameters() {
        return this.methodParameters;
    }

    public Map<String, Number> getNumbers() {
        return this.numbers;
    }

    public Map<String, Map<String, Number>> getMethodNumbers() {
        return this.methodNumbers;
    }

    public Map<String, URL> getUrls() {
        return this.urls;
    }

    public String getIp() {
        return this.ip;
    }

    public String getFull() {
        return this.full;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getString() {
        return this.string;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setMethodParameters(Map<String, Map<String, String>> methodParameters) {
        this.methodParameters = methodParameters;
    }

    public void setNumbers(Map<String, Number> numbers) {
        this.numbers = numbers;
    }

    public void setMethodNumbers(Map<String, Map<String, Number>> methodNumbers) {
        this.methodNumbers = methodNumbers;
    }

    public void setUrls(Map<String, URL> urls) {
        this.urls = urls;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setFull(String full) {
        this.full = full;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URL)) {
            return false;
        }
        URL other = (URL)o;
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, Map<String, String>> this$methodParameters = this.getMethodParameters();
        Map<String, Map<String, String>> other$methodParameters = other.getMethodParameters();
        return !(this$methodParameters == null ? other$methodParameters != null : !((Object)this$methodParameters).equals(other$methodParameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, Map<String, String>> $methodParameters = this.getMethodParameters();
        result = result * 59 + ($methodParameters == null ? 43 : ((Object)$methodParameters).hashCode());
        return result;
    }
}

