/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.template;

import cloud.tianai.remoting.api.RpcClientPostProcessor;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.core.configuration.RpcClientConfiguration;
import cloud.tianai.rpc.core.template.AbstractLoadBalanceRpcClientTemplate;
import java.util.List;

public class DefaultRpcClientTemplate
extends AbstractLoadBalanceRpcClientTemplate {
    private RpcClientConfiguration rpcClientConfiguration;
    private URL url;

    public DefaultRpcClientTemplate(RpcClientConfiguration rpcClientConfiguration, URL url) {
        this(rpcClientConfiguration, url, true, false, true);
    }

    public DefaultRpcClientTemplate(RpcClientConfiguration rpcClientConfiguration, URL url, boolean lazyLoadRegistry, boolean lazyLoadRemotingRpcClient, boolean lazyLoadLoadBalance) {
        this.rpcClientConfiguration = rpcClientConfiguration;
        this.url = url;
        List<RpcClientPostProcessor> postProcessors = rpcClientConfiguration.getRpcClientPostProcessors();
        if (CollectionUtils.isNotEmpty(postProcessors)) {
            postProcessors.forEach(this::addPostProcessor);
        }
        if (!lazyLoadLoadBalance) {
            this.initLoadBalance();
        }
        if (!lazyLoadRegistry) {
            this.initRegistryIfNecessary();
        }
        if (!lazyLoadRemotingRpcClient) {
            this.getRemotingClients();
        }
    }

    @Override
    public RpcClientConfiguration getConfig() {
        return this.rpcClientConfiguration;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }
}

