/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.factory;

import cloud.tianai.rpc.common.extension.ExtensionLoader;
import cloud.tianai.rpc.core.loadbalance.LoadBalance;
import cloud.tianai.rpc.core.loadbalance.impl.RandomLoadBalance;
import cloud.tianai.rpc.core.loadbalance.impl.RoundRobinLoadBalance;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LoadBalanceFactory {
    private static Map<String, LoadBalance> loadBalanceMap = new ConcurrentHashMap<String, LoadBalance>(2);

    public static LoadBalance getLoadBalance(String name) {
        return loadBalanceMap.get(name);
    }

    public static void addLoadBalance(LoadBalance loadBalance) {
        loadBalanceMap.remove(loadBalance.getName());
        loadBalanceMap.put(loadBalance.getName(), loadBalance);
    }

    public static void addLoadBalance(String name, LoadBalance loadBalance) {
        loadBalanceMap.remove(name);
        loadBalanceMap.put(name, loadBalance);
    }

    static {
        ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(LoadBalance.class);
        Map extensionClasses = extensionLoader.getExtensionClasses();
        Set keys = extensionClasses.keySet();
        for (String key : keys) {
            LoadBalance extension = (LoadBalance)extensionLoader.getExtension(key);
            LoadBalanceFactory.addLoadBalance(key, extension);
        }
        LoadBalanceFactory.addLoadBalance(new RoundRobinLoadBalance());
        LoadBalanceFactory.addLoadBalance(new RandomLoadBalance());
    }
}

