/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.factory;

import cloud.tianai.rpc.common.extension.ExtensionLoader;
import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataCodec;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class CodecFactory {
    private static Map<String, RemotingDataCodec> codecCache = new ConcurrentHashMap<String, RemotingDataCodec>(2);
    private static Map<String, Class<? extends RemotingDataCodec>> codecClassMap = new HashMap<String, Class<? extends RemotingDataCodec>>(2);

    public static void registerCodec(String protocol, String codecClassStr) throws ClassNotFoundException {
        Class codecClass = ClassUtils.forName((String)codecClassStr);
        if (!RemotingDataCodec.class.isAssignableFrom(codecClass)) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684 codec \u5fc5\u987b\u5b9e\u73b0 [RemotingDataCodec] \u63a5\u53e3");
        }
        Class codecClassCast = codecClass;
        CodecFactory.registerCodec(protocol, codecClassCast);
    }

    public static void registerCodec(String protocol, Class<? extends RemotingDataCodec> codecClass) {
        codecClassMap.remove(protocol);
        codecClassMap.put(protocol, codecClass);
    }

    public static RemotingDataCodec getCodec(String protocol) {
        RemotingDataCodec result = codecCache.computeIfAbsent(protocol, p -> {
            Class<? extends RemotingDataCodec> codecClass = codecClassMap.get(protocol);
            RemotingDataCodec res = null;
            if (codecClass != null) {
                try {
                    res = CodecFactory.createCodec(protocol, codecClass);
                    codecClassMap.remove(protocol);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return res;
        });
        return result;
    }

    private static RemotingDataCodec createCodec(String protocol, Class<? extends RemotingDataCodec> codecClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        RemotingDataCodec res = codecCache.get(protocol);
        if (!Objects.isNull(res)) {
            return res;
        }
        res = (RemotingDataCodec)ClassUtils.createObject(codecClass, (Object[])new Object[0]);
        return res;
    }

    static {
        ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(RemotingDataCodec.class);
        Map extensionClasses = extensionLoader.getExtensionClasses();
        extensionClasses.forEach(CodecFactory::registerCodec);
    }
}

