/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.bootstrap;

import cloud.tianai.remoting.api.DefaultRpcInvocation;
import cloud.tianai.remoting.api.RemotingChannelHolder;
import cloud.tianai.remoting.api.RemotingConfiguration;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.api.RemotingServer;
import cloud.tianai.remoting.api.RemotingServerConfiguration;
import cloud.tianai.remoting.api.RequestResponseRemotingDataProcessor;
import cloud.tianai.remoting.api.RpcInvocation;
import cloud.tianai.remoting.api.RpcInvocationPostProcessor;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.constant.CommonConstant;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.common.util.IPUtils;
import cloud.tianai.rpc.core.configuration.RpcServerConfiguration;
import cloud.tianai.rpc.core.factory.CodecFactory;
import cloud.tianai.rpc.core.factory.RemotingServerFactory;
import cloud.tianai.rpc.core.holder.RegistryHolder;
import cloud.tianai.rpc.core.holder.RpcServerHolder;
import cloud.tianai.rpc.core.util.RegistryUtils;
import cloud.tianai.rpc.registory.api.Registry;
import cloud.tianai.rpc.registory.api.exception.RpcRegistryException;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataCodec;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBootstrap {
    private static final Logger log = LoggerFactory.getLogger(ServerBootstrap.class);
    private RpcServerConfiguration prop = new RpcServerConfiguration();
    private RemotingServer remotingServer;
    private Registry registry;
    private RemotingChannelHolder channelHolder;
    private AtomicBoolean start = new AtomicBoolean(false);
    private DefaultRpcInvocation rpcInvocation = new DefaultRpcInvocation();
    Map<URL, Object> temporaryObjectMap = new ConcurrentHashMap<URL, Object>(256);

    public ServerBootstrap server(String server) {
        this.prop.setProtocol(server);
        return this;
    }

    public ServerBootstrap host(String host) {
        this.prop.setHost(host);
        return this;
    }

    public ServerBootstrap port(Integer port) {
        this.prop.setPort(port);
        return this;
    }

    public ServerBootstrap address(InetSocketAddress address) {
        String host = address.getHostString();
        int port = address.getPort();
        return this.host(host).port(port);
    }

    public ServerBootstrap codec(String codec) {
        this.prop.setCodec(codec);
        return this;
    }

    public ServerBootstrap registry(URL registryConfig) {
        this.prop.setRegistryUrl(registryConfig);
        return this;
    }

    public ServerBootstrap workThreads(Integer threads) {
        this.prop.setWorkerThread(threads);
        return this;
    }

    public ServerBootstrap bossThreads(Integer threads) {
        this.prop.setBossThreads(threads);
        return this;
    }

    public ServerBootstrap timeout(Integer timeout) {
        this.prop.setTimeout(timeout);
        return this;
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            throw new RpcException("\u8be5\u670d\u52a1\u5df2\u7ecf\u542f\u52a8\uff0c\u8bf7\u52ff\u91cd\u590d\u542f\u52a8[host=" + this.prop.getHost() + ", port=" + this.prop.getPort() + "]");
        }
        this.startRemotingServer();
        this.startRegistry();
        this.temporaryObjectMap = Collections.unmodifiableMap(this.temporaryObjectMap);
        if (this.temporaryObjectMap.size() > 0) {
            this.temporaryObjectMap.forEach(this::register);
        }
    }

    public RemotingChannelHolder getChannel() {
        if (this.remotingServer == null) {
            return null;
        }
        return this.remotingServer.getChannel();
    }

    public ServerBootstrap register(Class<?> interfaceClazz, Object ref) {
        this.register(interfaceClazz, ref, CommonConstant.DEFAULT_WEIGHT);
        return this;
    }

    public ServerBootstrap register(Class<?> interfaceClazz, Object ref, Integer weight) {
        this.register(interfaceClazz, ref, Collections.singletonMap("weight", String.valueOf(weight)));
        return this;
    }

    public ServerBootstrap register(Class<?> interfaceClazz, Object ref, Map<String, String> parameters) {
        URL url = new URL(this.remotingServer.getRemotingType(), this.prop.getHost(), this.prop.getPort().intValue(), interfaceClazz.getName(), parameters);
        if (!this.isStart()) {
            this.temporaryObjectMap.put(url, ref);
            return this;
        }
        this.registry.register(url);
        this.rpcInvocation.putInvokeObj(interfaceClazz, ref);
        return this;
    }

    public ServerBootstrap register(URL url, Object ref) {
        Class interfaceClazz;
        if (!this.isStart()) {
            this.temporaryObjectMap.put(url, ref);
            return this;
        }
        try {
            interfaceClazz = ClassUtils.forName((String)url.getPath());
        }
        catch (ClassNotFoundException e) {
            throw new RpcRegistryException("\u6ce8\u518c\u5730\u5740\u5931\u8d25\uff0c path\u6307\u5b9a\u7684\u503c\u5fc5\u987b\u662fclass\u7c7b\u578b\uff0c\u4e14\u53ef\u88ab\u627e\u5230, path=" + url.getPath(), (Throwable)e);
        }
        this.registry.register(url);
        this.rpcInvocation.putInvokeObj(interfaceClazz, ref);
        return this;
    }

    public boolean isStart() {
        return this.start.get();
    }

    public String getServerAddress() {
        String host = this.prop.getHost();
        Integer port = this.prop.getPort();
        if (host == null) {
            host = IPUtils.getHostIp();
        }
        if (port == null) {
            return host;
        }
        assert (host != null);
        return host.concat(":").concat(String.valueOf(port));
    }

    private void startRemotingServer() {
        this.remotingServer = RpcServerHolder.computeIfAbsent(this.prop.getProtocol(), this.getServerAddress(), (s, a) -> {
            RemotingServer r = RemotingServerFactory.create(s);
            if (Objects.isNull(r)) {
                throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8fdc\u7a0bserver, server=" + s);
            }
            List<RpcInvocationPostProcessor> postProcessors = this.prop.getInvocationPostProcessors();
            if (CollectionUtils.isNotEmpty(postProcessors)) {
                postProcessors.forEach(arg_0 -> ((DefaultRpcInvocation)this.rpcInvocation).addPostProcessor(arg_0));
            }
            RemotingServerConfiguration conf = this.getRemotingServerConfiguration();
            r.start((RemotingConfiguration)conf);
            return r;
        });
    }

    private RemotingServerConfiguration getRemotingServerConfiguration() {
        RemotingServerConfiguration remotingServerConfiguration = new RemotingServerConfiguration();
        remotingServerConfiguration.setHost(this.prop.getHost());
        remotingServerConfiguration.setPort(this.prop.getPort());
        remotingServerConfiguration.setWorkerThreads(this.prop.getWorkerThread());
        RemotingDataCodec codec = CodecFactory.getCodec(this.prop.getCodec());
        if (codec == null) {
            throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684codec\uff0c codec=".concat(this.prop.getCodec()));
        }
        remotingServerConfiguration.setCodec(codec);
        RequestResponseRemotingDataProcessor remotingDataProcessor = new RequestResponseRemotingDataProcessor((RpcInvocation)this.rpcInvocation);
        remotingServerConfiguration.setRemotingDataProcessor((RemotingDataProcessor)remotingDataProcessor);
        remotingServerConfiguration.setConnectTimeout(this.prop.getTimeout());
        remotingServerConfiguration.setServerIdleTimeout(this.prop.getIdleTimeout());
        remotingServerConfiguration.setBossThreads(this.prop.getBossThreads());
        return remotingServerConfiguration;
    }

    private void startRegistry() {
        this.registry = RegistryHolder.computeIfAbsent(this.prop.getRegistryUrl(), RegistryUtils::createAndStart);
    }

    public void shutdown() {
        if (this.start.compareAndSet(true, false) && this.remotingServer != null) {
            this.remotingServer.stop();
        }
    }

    public RpcServerConfiguration getProp() {
        return this.prop;
    }

    public void setProp(RpcServerConfiguration prop) {
        this.prop = prop;
    }
}

