/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.netty;

import cloud.tianai.rpc.remoting.codec.api.RemotingDataCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDecoder
extends ReplayingDecoder<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(NettyDecoder.class);
    private RemotingDataCodec codec;

    public NettyDecoder(RemotingDataCodec codec) {
        this.codec = codec;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        byte[] bytes = new byte[in.readInt()];
        try {
            in.readBytes(bytes);
            Object decode = this.codec.getDecoder().decode(bytes, Object.class);
            out.add(decode);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("TIANAI-RPC NettyServerHandler , \u89e3\u7801\u5f02\u5e38, ex={}, data={}", (Object)e, (Object)bytes);
            } else {
                System.out.println("TIANAI-RPC NettyServerHandler , \u89e3\u7801\u5f02\u5e38, ex=" + e.getLocalizedMessage() + ", data=" + bytes);
            }
            throw e;
        }
    }
}

