/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.netty;

import cloud.tianai.remoting.api.AbstractRemotingClient;
import cloud.tianai.remoting.api.RemotingChannelHolder;
import cloud.tianai.remoting.api.RemotingConfiguration;
import cloud.tianai.remoting.api.exception.RpcRemotingException;
import cloud.tianai.remoting.netty.NettyClientHandler;
import cloud.tianai.remoting.netty.NettyDecoder;
import cloud.tianai.remoting.netty.NettyEncoder;
import cloud.tianai.remoting.netty.NettyRemotingChannelHolder;
import cloud.tianai.rpc.common.util.ThreadUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
extends AbstractRemotingClient {
    private static final Logger log = LoggerFactory.getLogger(NettyClient.class);
    public static final String REMOTING_TYPE = "NETTY";
    private Channel channel;
    private EventLoopGroup workerGroup;
    private NettyRemotingChannelHolder channelHolder;
    private Bootstrap bootstrap;
    private RemotingConfiguration config;

    public RemotingChannelHolder doStart(RemotingConfiguration config) throws RpcRemotingException {
        this.bootstrap = new Bootstrap();
        this.config = config;
        this.initEventLoopGroup(config);
        this.warpBootStrap(this.bootstrap, config);
        this.channel = this.connect(this.bootstrap, config);
        this.channelHolder = NettyRemotingChannelHolder.create(this.channel);
        return this.channelHolder;
    }

    private Channel connect(Bootstrap bs, RemotingConfiguration config) {
        ChannelFuture channelFuture = bs.connect((SocketAddress)new InetSocketAddress(config.getHost(), (int)config.getPort()));
        boolean ret = channelFuture.awaitUninterruptibly((long)config.getConnectTimeout().intValue(), TimeUnit.MILLISECONDS);
        if (ret && channelFuture.isSuccess()) {
            this.channel = channelFuture.channel();
            return this.channel;
        }
        throw new RpcRemotingException("client\u94fe\u63a5\u8d85\u65f6, host=[" + config.getHost() + "], port=[" + config.getPort() + "], \u8d85\u65f6\u65f6\u95f4:" + config.getConnectTimeout() + TimeUnit.MILLISECONDS.toString());
    }

    private void warpBootStrap(Bootstrap bs, final RemotingConfiguration config) {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bs.channel(Epoll.isAvailable() ? EpollSocketChannel.class : NioSocketChannel.class)).group(this.workerGroup)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.max(3000, config.getConnectTimeout()))).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("Encoder", (ChannelHandler)new NettyEncoder(config.getCodec(), config.getRemotingDataProcessor()));
                pipeline.addLast("Decoder", (ChannelHandler)new NettyDecoder(config.getCodec()));
                pipeline.addLast("client-idle-handler", (ChannelHandler)new IdleStateHandler((long)config.getIdleTimeout().intValue(), 0L, 0L, TimeUnit.MILLISECONDS));
                pipeline.addLast("handler", (ChannelHandler)new NettyClientHandler(config.getRemotingDataProcessor()));
            }
        });
    }

    private void initEventLoopGroup(RemotingConfiguration config) {
        if (this.workerGroup == null) {
            this.workerGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(config.getWorkerThreads().intValue()) : new NioEventLoopGroup(config.getWorkerThreads().intValue());
        }
    }

    public void doStop() throws RpcRemotingException {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public RemotingChannelHolder getChannel() {
        return this.channelHolder;
    }

    public String getRemotingType() {
        return REMOTING_TYPE;
    }

    public void doConnect() {
        if (this.channel != null && this.channel.isOpen()) {
            log.info("\u5173\u95edchannel\u8fdb\u884c\u91cd\u8fde....");
            this.channel.disconnect();
        }
        Channel channel = this.connect(this.bootstrap, this.config);
        log.info("\u8fde\u63a5channel:" + channel.remoteAddress());
        this.channelHolder.setChannel(channel);
    }

    public void reconnect(int retryCount) throws TimeoutException {
        this.reconnect(0, Math.max(retryCount, 1));
    }

    protected void reconnect(int currRetryCount, int retryCount) throws TimeoutException {
        try {
            this.doConnect();
        }
        catch (RpcRemotingException ex) {
            if (currRetryCount < retryCount) {
                ThreadUtils.sleep((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                this.reconnect(++currRetryCount, retryCount);
            }
            throw new TimeoutException(ex.getMessage());
        }
    }

    public SocketAddress getRemoteAddress() {
        if (this.channel != null) {
            return this.channel.remoteAddress();
        }
        return null;
    }
}

