/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.loader;

import cloud.tianai.rpc.common.util.ClassUtils;
import cloud.tianai.rpc.core.factory.CodecFactory;
import cloud.tianai.rpc.core.factory.RegistryFactory;
import cloud.tianai.rpc.core.factory.RemotingClientFactory;
import cloud.tianai.rpc.core.factory.RemotingServerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcPropertiesLoader {
    private static final Logger log = LoggerFactory.getLogger(RpcPropertiesLoader.class);
    public static final String PROPERTIES_PATH = "META-INF/dubbo/";
    public static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*[,]+\\s*");
    private static AtomicBoolean load = new AtomicBoolean(false);
    private static Map<String, Properties> loadProperties = new ConcurrentHashMap<String, Properties>();

    public static void loadIfNecessary() {
        if (!load.compareAndSet(false, true)) {
            return;
        }
        RpcPropertiesLoader.processRegistry();
        RpcPropertiesLoader.processRemotingServer();
        RpcPropertiesLoader.processRemotingClient();
        RpcPropertiesLoader.processCodec();
    }

    private static void processCodec() {
        RpcPropertiesLoader.processProperties(CodecFactory.class.getName(), 2, datas -> datas.forEach((k, v) -> {
            try {
                CodecFactory.registerCodec(k, v[0], v[1]);
            }
            catch (ClassNotFoundException e) {
                log.error("\u52a0\u8f7d \u5e8f\u5217\u5316 \u5931\u8d25\uff0c \u672a\u627e\u5230\u8be5class {}", (Object)Arrays.toString(v));
            }
        }));
    }

    private static void processRemotingClient() {
        RpcPropertiesLoader.processProperties(RemotingClientFactory.class.getName(), 1, datas -> datas.forEach((k, v) -> {
            try {
                RemotingClientFactory.addRemotingClient(k, v[0]);
            }
            catch (ClassNotFoundException e) {
                log.error("\u52a0\u8f7d \u8fdc\u7a0bClient \u5931\u8d25\uff0c \u672a\u627e\u5230\u8be5class {}", (Object)Arrays.toString(v));
            }
        }));
    }

    private static void processRemotingServer() {
        RpcPropertiesLoader.processProperties(RemotingServerFactory.class.getName(), 1, datas -> datas.forEach((k, v) -> {
            try {
                RemotingServerFactory.addRemotingServer(k, v[0]);
            }
            catch (ClassNotFoundException e) {
                log.error("\u52a0\u8f7d \u8fdc\u7a0bServer \u5931\u8d25\uff0c \u672a\u627e\u5230\u8be5class {}", (Object)Arrays.toString(v));
            }
        }));
    }

    private static void processRegistry() {
        RpcPropertiesLoader.processProperties(RegistryFactory.class.getName(), 1, dataMap -> dataMap.forEach((k, v) -> {
            try {
                RegistryFactory.addRegistry(k, v[0]);
            }
            catch (ClassNotFoundException e) {
                log.error("\u52a0\u8f7d REGISTRY \u5931\u8d25\uff0c \u672a\u627e\u5230\u8be5class {}", (Object)Arrays.toString(v));
            }
        }));
    }

    private static void processProperties(String name, int splitLen, Consumer<Map<String, String[]>> consumer) {
        Properties properties = loadProperties.computeIfAbsent(name, k -> {
            Properties prop = new Properties();
            return RpcPropertiesLoader.loadProperties(k, prop);
        });
        HashMap consumerData = new HashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String[] split = SPLIT_PATTERN.split(String.valueOf(v));
            if (split.length != splitLen) {
                throw new IllegalStateException("\u89e3\u6790 [" + k + "] \u5931\u8d25\uff0c \u5339\u914d\u89c4\u5219\u9519\u8bef\uff0c data=" + v + ", splitLen=" + splitLen + ", splitFlag=" + SPLIT_PATTERN);
            }
            consumerData.put(String.valueOf(k), split);
        }));
        consumer.accept(consumerData);
    }

    private static Properties loadProperties(String name, Properties prop) {
        Enumeration<URL> resources;
        try {
            resources = ClassUtils.getClassLoader().getResources(PROPERTIES_PATH.concat(name));
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7d{}\u5f02\u5e38e={}", (Object)PROPERTIES_PATH, (Object)e);
            return prop;
        }
        if (resources != null && resources.hasMoreElements()) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    InputStream inputStream = url.openStream();
                    prop.load(inputStream);
                }
                catch (IOException e) {
                    log.error("\u52a0\u8f7d{}\u5f02\u5e38e={}", (Object)PROPERTIES_PATH, (Object)e);
                }
            }
        }
        return prop;
    }

    private static Map<String, Properties> converterProperties(Map<String, List<File>> loadFiles) {
        ConcurrentHashMap<String, Properties> propertiesMap = new ConcurrentHashMap<String, Properties>(loadFiles.size());
        loadFiles.forEach((key, files) -> {
            Properties prop = propertiesMap.computeIfAbsent((String)key, k -> new Properties());
            for (File file : files) {
                try {
                    prop.load(new FileInputStream(file));
                }
                catch (IOException e) {
                    log.error("\u52a0\u8f7d{}\u5f02\u5e38e={}", (Object)PROPERTIES_PATH, (Object)e);
                }
            }
        });
        return propertiesMap;
    }

    private static List<URL> readUrls(Enumeration<URL> resources) {
        if (resources != null && resources.hasMoreElements()) {
            LinkedList<URL> urls = new LinkedList<URL>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                urls.add(url);
            }
            return urls;
        }
        return Collections.emptyList();
    }

    public static boolean isLoad() {
        return load.get();
    }

    public static Map<String, Properties> getLoadProperties() {
        return loadProperties;
    }
}

