/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.netty;

import cloud.tianai.remoting.api.Channel;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.netty.NettyChannelAdapter;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerHandler
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(NettyServerHandler.class);
    private RemotingDataProcessor remotingDataProcessor;
    ExecutorService executorService;

    public NettyServerHandler(ExecutorService executorService, RemotingDataProcessor remotingDataProcessor) {
        this.executorService = executorService;
        this.remotingDataProcessor = remotingDataProcessor;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.executorService != null) {
            this.executorService.execute(new NettyRunnable(ctx, msg, this.remotingDataProcessor));
        } else {
            new NettyRunnable(ctx, msg, this.remotingDataProcessor).run();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        NettyChannelAdapter channelAdapter = new NettyChannelAdapter(ctx.channel());
        msg = this.remotingDataProcessor.writeMessage((Channel)channelAdapter, msg, (Object)ctx);
        if (msg != null) {
            super.write(ctx, msg, promise);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
        super.exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.close();
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public static class NettyRunnable
    implements Runnable {
        private ChannelHandlerContext ctx;
        private Object msg;
        private RemotingDataProcessor processor;

        public NettyRunnable(ChannelHandlerContext ctx, Object msg, RemotingDataProcessor processor) {
            this.ctx = ctx;
            this.msg = msg;
            this.processor = processor;
        }

        @Override
        public void run() {
            if (this.processor.support(this.msg)) {
                NettyChannelAdapter channelAdapter = new NettyChannelAdapter(this.ctx.channel());
                this.processor.readMessage((Channel)channelAdapter, this.msg, (Object)this.ctx);
            } else {
                try {
                    this.ctx.fireChannelRead(this.msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

