/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.netty;

import cloud.tianai.remoting.api.AbstractRemotingServer;
import cloud.tianai.remoting.api.RemotingChannelHolder;
import cloud.tianai.remoting.api.RemotingServerConfiguration;
import cloud.tianai.remoting.api.exception.RpcRemotingException;
import cloud.tianai.remoting.netty.NettyDecoder;
import cloud.tianai.remoting.netty.NettyEncoder;
import cloud.tianai.remoting.netty.NettyRemotingChannelHolder;
import cloud.tianai.remoting.netty.NettyServerHandler;
import cloud.tianai.rpc.common.threadpool.NamedThreadFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
extends AbstractRemotingServer {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    public static final String SERVER_TYPE = "NETTY_SERVER";
    public static final Integer DEFAULT_PORT = 20880;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private InetSocketAddress address;
    private NettyRemotingChannelHolder channelHolder;
    private RemotingServerConfiguration remotingServerConfiguration;
    ExecutorService threadPool;

    public RemotingChannelHolder doStart(RemotingServerConfiguration config) throws RpcRemotingException {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        this.initThreadLocal(config);
        this.initEventLoopGroup(config);
        this.warpBootStrap(serverBootstrap, config);
        ChannelFuture channelFuture = this.bind(serverBootstrap, config);
        channelFuture.syncUninterruptibly();
        if (channelFuture.isSuccess()) {
            if (log.isInfoEnabled()) {
                log.info("[tianai-rpc] - Netty start, address[{}]", (Object)channelFuture.channel().localAddress());
            } else {
                System.out.println("[tianai-rpc] - Netty start, address[" + channelFuture.channel().localAddress() + "]");
            }
        }
        this.channel = channelFuture.channel();
        this.channelHolder = NettyRemotingChannelHolder.create(this.channel);
        this.remotingServerConfiguration = config;
        return this.channelHolder;
    }

    private void initThreadLocal(RemotingServerConfiguration config) {
        this.threadPool = config.getThreadPool() != null ? config.getThreadPool() : new ThreadPoolExecutor(200, 200, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), (ThreadFactory)new NamedThreadFactory("tianai-rpc-svc", false), new ThreadPoolExecutor.AbortPolicy());
    }

    private ChannelFuture bind(ServerBootstrap serverBootstrap, RemotingServerConfiguration config) {
        String host = config.getHost();
        Integer port = config.getPort() == null || config.getPort() < 1 ? DEFAULT_PORT : config.getPort();
        this.address = StringUtils.isBlank((CharSequence)config.getHost()) ? new InetSocketAddress(port) : new InetSocketAddress(host, (int)port);
        return serverBootstrap.bind((SocketAddress)this.address);
    }

    private void warpBootStrap(ServerBootstrap serverBootstrap, final RemotingServerConfiguration config) {
        ((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("Encoder", (ChannelHandler)new NettyEncoder(config.getEncoder(), config.getRemotingDataProcessor()));
                pipeline.addLast("Decoder", (ChannelHandler)new NettyDecoder(config.getDecoder()));
                pipeline.addLast("server-idle-handler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)config.getServerIdleTimeout().intValue(), TimeUnit.MILLISECONDS));
                pipeline.addLast("handler", (ChannelHandler)new NettyServerHandler(NettyServer.this.threadPool, config.getRemotingDataProcessor()));
            }
        });
    }

    private void initEventLoopGroup(RemotingServerConfiguration config) {
        if (this.bossGroup != null && this.workerGroup != null) {
            return;
        }
        if (Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup(config.getBossThreads().intValue());
            this.workerGroup = new EpollEventLoopGroup(config.getWorkerThreads().intValue());
        } else {
            this.bossGroup = new NioEventLoopGroup(config.getBossThreads().intValue());
            this.workerGroup = new NioEventLoopGroup(config.getWorkerThreads().intValue());
        }
    }

    public void doStop() throws RpcRemotingException {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public RemotingChannelHolder getChannel() {
        return this.channelHolder;
    }

    public String getRemotingType() {
        return SERVER_TYPE;
    }

    public RemotingServerConfiguration getRemotingServerConfiguration() {
        return this.remotingServerConfiguration;
    }
}

