/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.netty;

import cloud.tianai.remoting.api.Channel;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.netty.NettyChannelAdapter;
import cloud.tianai.rpc.remoting.codec.api.RemotingDataEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class NettyEncoder
extends MessageToByteEncoder<Object> {
    private RemotingDataEncoder encoder;
    private RemotingDataProcessor dataProcessor;

    public NettyEncoder(RemotingDataEncoder encoder, RemotingDataProcessor dataProcessor) {
        this.encoder = encoder;
        this.dataProcessor = dataProcessor;
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        try {
            byte[] bytes = this.encoder.encode(msg);
            out.writeInt(bytes.length);
            out.writeBytes(bytes);
        }
        catch (Exception ex) {
            if (this.dataProcessor.support(msg)) {
                this.dataProcessor.sendError((Channel)new NettyChannelAdapter(ctx.channel()), (Throwable)ex, msg);
            }
            throw ex;
        }
    }
}

