/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.registry.zookeeper;

import cloud.tianai.rpc.common.Result;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.util.CollectionUtils;
import cloud.tianai.rpc.common.util.ThreadUtils;
import cloud.tianai.rpc.registory.api.AbstractRegistry;
import cloud.tianai.rpc.registory.api.NotifyListener;
import cloud.tianai.rpc.registory.api.StatusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperRegistry
extends AbstractRegistry {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRegistry.class);
    public static final String PROTOCOL = "zookeeper";
    private static final String DEFAULT_ROOT = "/tianai-rpc";
    private static final String PATH_SEPARATOR = "/";
    private Map<NotifyListener, IZkChildListener> notifyListenerZkDataListenerMap = new HashMap<NotifyListener, IZkChildListener>(32);
    public static final String GROUP_KEY = "group";
    private ZkClient zkClient;
    private String root;

    protected void doShutdown() {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        this.notifyListenerZkDataListenerMap.clear();
    }

    protected void doStart(URL url) throws TimeoutException {
        Integer retryCount = this.getRetryCount();
        this.init(0, Math.max(retryCount, 1));
    }

    protected void innerRegister(URL url) {
        try {
            try {
                String path = this.getPath(url);
                this.create(path + PATH_SEPARATOR + URL.encode((String)url.toString()));
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        catch (ZkNoNodeException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected void doSubscribe(StatusListener statusListener) {
    }

    private void init(int currentRetryCount, int retryCount) throws TimeoutException {
        String address = this.getRegistryUrl().getAddress();
        int timeout = Integer.parseInt(this.getRegistryUrl().getParameter("timeout", String.valueOf(5000)));
        try {
            this.zkClient = new ZkClient(address, timeout);
        }
        catch (Exception e) {
            if (currentRetryCount > retryCount) {
                throw new TimeoutException(e.getMessage());
            }
            ThreadUtils.sleep((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.init(++currentRetryCount, retryCount);
        }
        this.zkClient.subscribeStateChanges((IZkStateListener)new WatcherListener(this.getStatusListenerSet()));
        this.root = this.getRegistryUrl().getParameter(GROUP_KEY, DEFAULT_ROOT);
        this.createNodeIfNecessary(this.root, CreateMode.PERSISTENT);
    }

    private void createNodeIfNecessary(String node, CreateMode createMode) {
        if (this.zkClient.exists(node)) {
            return;
        }
        this.zkClient.create(node, null, createMode);
    }

    private String getPath(URL url) {
        return this.toRootPath() + PATH_SEPARATOR + url.getServiceInterface();
    }

    public Result<List<URL>> lookup(URL url) {
        List urls = Collections.emptyList();
        try {
            List children = this.zkClient.getChildren(this.getPath(url));
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                urls = new ArrayList(children.size());
                for (String child : children) {
                    String decodeChild = URL.decode((String)child);
                    URL u = URL.valueOf((String)decodeChild);
                    urls.add(u);
                }
            }
            return Result.ofSuccess(urls);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.ofError((String)e.getMessage());
        }
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public void subscribe(URL url, NotifyListener listener) {
        String path = this.getPath(url);
        if (!this.zkClient.exists(path)) {
            this.create(path + PATH_SEPARATOR + URL.encode((String)url.toString()));
        }
        ZkChildListenerAdapter zkChildListenerAdapter = new ZkChildListenerAdapter(listener);
        this.zkClient.subscribeChildChanges(path, (IZkChildListener)zkChildListenerAdapter);
        this.notifyListenerZkDataListenerMap.put(listener, zkChildListenerAdapter);
    }

    public void unsubscribe(URL url, NotifyListener listener) {
        IZkChildListener iZkChildListener = this.notifyListenerZkDataListenerMap.get(listener);
        if (!Objects.isNull(iZkChildListener)) {
            this.zkClient.unsubscribeChildChanges(this.getPath(url), iZkChildListener);
        }
    }

    public void destroy() {
        if (this.zkClient != null) {
            try {
                this.zkClient.close();
                this.zkClient = null;
            }
            catch (Exception e) {
                log.error("the service zk close faild info={}", (Object)this.getRegistryUrl());
            }
        }
    }

    private String toRootPath() {
        return this.root;
    }

    public void create(String path) {
        int indexOf = path.lastIndexOf(PATH_SEPARATOR);
        if (indexOf > 0) {
            this.createPersistent(path.substring(0, indexOf));
        }
        this.createEphemeral(path);
    }

    private void createEphemeral(String path) {
        try {
            this.zkClient.createEphemeral(path);
        }
        catch (ZkNodeExistsException e) {
            this.deleteNode(path);
            this.createEphemeral(path);
        }
    }

    private void deleteNode(String path) {
        this.zkClient.delete(path);
    }

    private void createPersistent(String path) {
        int i = path.lastIndexOf(47);
        if (i > 0) {
            this.createPersistent(path.substring(0, i));
        }
        if (!this.zkClient.exists(path)) {
            try {
                this.zkClient.createPersistent(path);
            }
            catch (ZkNodeExistsException e) {
                log.warn("ZNode " + path + " already exists.", (Throwable)e);
            }
        }
    }

    public static class ZkChildListenerAdapter
    implements IZkChildListener {
        private NotifyListener notifyListener;

        public ZkChildListenerAdapter(NotifyListener notifyListener) {
            this.notifyListener = notifyListener;
        }

        public void handleChildChange(String parentPath, List<String> currentChilds) {
            if (CollectionUtils.isEmpty(currentChilds)) {
                this.notifyListener.notify(Collections.emptyList());
            } else {
                ArrayList<URL> urls = new ArrayList<URL>(currentChilds.size());
                for (String child : currentChilds) {
                    String urlDecode = URL.decode((String)child);
                    urls.add(URL.valueOf((String)urlDecode));
                }
                this.notifyListener.notify(urls);
            }
        }
    }

    private class WatcherListener
    implements IZkStateListener {
        private Set<StatusListener> statusListenerSet;

        public WatcherListener(Set<StatusListener> statusListenerSet) {
            this.statusListenerSet = statusListenerSet;
        }

        public void handleStateChanged(Watcher.Event.KeeperState state) {
            log.info("handleStateChanged() ===> {}", (Object)state);
            if (Watcher.Event.KeeperState.Expired == state || Watcher.Event.KeeperState.Disconnected == state) {
                log.info("\u91cd\u8fdezookeeper ===> ");
                this.reConnected();
            }
        }

        public void handleNewSession() {
            if (log.isInfoEnabled()) {
                log.info("zookeeper new session ========-------->, \u91cd\u65b0\u6ce8\u518c, addressCache={}", (Object)ZookeeperRegistry.this.getRegistryUrlMap());
            } else {
                System.out.println("new session------------==============================>, addressCache=" + ZookeeperRegistry.this.getRegistryUrlMap());
            }
            ZookeeperRegistry.this.reRegister();
        }

        public void handleSessionEstablishmentError(Throwable error) {
            log.warn("zookeeper\u56de\u8bdd\u5efa\u7acb\u9519\u8bef\uff0c e=", error);
            this.reConnected();
        }

        private void reConnected() {
            try {
                ZookeeperRegistry.this.destroy();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                Integer retryCount = ZookeeperRegistry.this.getRetryCount();
                ZookeeperRegistry.this.init(0, Math.max(retryCount, 1));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.reConnected();
                return;
            }
            ZookeeperRegistry.this.reRegister();
            for (StatusListener statusListener : this.statusListenerSet) {
                statusListener.reConnected();
            }
        }
    }
}

