/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.client.proxy;

import cloud.tianai.rpc.core.client.proxy.RpcProxy;
import cloud.tianai.rpc.core.client.proxy.RpcProxyType;
import cloud.tianai.rpc.core.client.proxy.impl.javassist.JavassistRpcProxy;
import cloud.tianai.rpc.core.client.proxy.impl.jdk.JdkRpcProxy;
import cloud.tianai.rpc.core.configuration.RpcClientConfiguration;

public class RpcProxyFactory {
    public static <T> T create(Class<T> interfaceClass, RpcClientConfiguration prop, RpcProxyType type) {
        RpcProxy<T> rpcProxy = RpcProxyFactory.getRpcProxy(interfaceClass, type);
        return rpcProxy.createProxy(interfaceClass, prop);
    }

    private static <T> RpcProxy<T> getRpcProxy(Class<T> clazz, RpcProxyType type) {
        switch (type) {
            case JDK_PROXY: {
                return new JdkRpcProxy();
            }
            case JAVASSIST_PROXY: {
                return new JavassistRpcProxy();
            }
        }
        return new JavassistRpcProxy();
    }
}

