/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.core.bootstrap;

import cloud.tianai.remoting.api.RemotingClient;
import cloud.tianai.remoting.api.RemotingConfiguration;
import cloud.tianai.rpc.common.URL;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.core.factory.RemotingClientFactory;
import cloud.tianai.rpc.core.holder.RpcClientHolder;
import cloud.tianai.rpc.core.loader.RpcPropertiesLoader;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class Bootstrap {
    private AtomicBoolean start = new AtomicBoolean(false);
    private RemotingClient remotingClient;
    private String protocol = "netty";
    private URL url;
    private RemotingConfiguration conf = new RemotingConfiguration();
    private String client = "netty";
    private String codec = "hessian2";

    public Bootstrap codec(String codec) {
        this.codec = codec;
        return this;
    }

    private Bootstrap timeout(Integer timeout) {
        this.conf.setConnectTimeout(timeout);
        return this;
    }

    public Bootstrap client(String client) {
        this.client = client;
        return this;
    }

    public RemotingClient start(URL url) throws RpcException {
        RpcPropertiesLoader.loadIfNecessary();
        if (this.start.compareAndSet(false, true)) {
            try {
                this.url = url;
                this.startRemotingClient();
            }
            finally {
                this.start.set(false);
            }
        }
        return this.remotingClient;
    }

    private void startRemotingClient() {
        this.remotingClient = RpcClientHolder.computeIfAbsent(this.protocol, this.url.getAddress(), (p, u) -> {
            RemotingClient r = RemotingClientFactory.create(this.protocol);
            if (Objects.isNull(r)) {
                throw new RpcException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8fdc\u7a0bserver, protocol=" + this.protocol);
            }
            r.start(this.conf);
            return r;
        });
    }

    public void shutdown() {
        if (this.start.compareAndSet(true, false) && this.remotingClient != null) {
            this.remotingClient.stop();
        }
    }

    public boolean isStart() {
        return this.start.get();
    }

    public RemotingConfiguration getConf() {
        return this.conf;
    }
}

