/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.netty;

import cloud.tianai.remoting.api.Channel;
import cloud.tianai.remoting.api.DefaultFuture;
import cloud.tianai.remoting.api.RemotingChannelHolder;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.exception.RpcChannelClosedException;
import cloud.tianai.remoting.netty.NettyChannelAdapter;
import io.netty.channel.ChannelFuture;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;

public class NettyRemotingChannelHolder
implements RemotingChannelHolder {
    private io.netty.channel.Channel nettyChannel;
    private Channel channel;

    public NettyRemotingChannelHolder(io.netty.channel.Channel nettyChannel) {
        this.nettyChannel = nettyChannel;
        this.channel = new NettyChannelAdapter(nettyChannel);
    }

    public void setChannel(io.netty.channel.Channel nettyChannel) {
        this.nettyChannel = nettyChannel;
        this.channel = new NettyChannelAdapter(nettyChannel);
    }

    public static NettyRemotingChannelHolder create(io.netty.channel.Channel channel) {
        NettyRemotingChannelHolder channelHolder = new NettyRemotingChannelHolder(channel);
        return channelHolder;
    }

    public String getChannelType() {
        return "NETTY_SERVER";
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CompletableFuture<Object> request(Request request, int timeout) {
        DefaultFuture future = DefaultFuture.newFuture((Channel)this.channel, (Request)request, (int)timeout);
        ChannelFuture channelFuture = this.nettyChannel.writeAndFlush((Object)request);
        channelFuture.addListener(ch -> {
            Throwable cause = ch.cause();
            if (cause != null) {
                if (cause instanceof ClosedChannelException) {
                    future.obtrudeException((Throwable)new RpcChannelClosedException());
                } else {
                    future.obtrudeException(cause);
                }
            }
        });
        return future;
    }
}

