/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.netty;

import cloud.tianai.remoting.api.Channel;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.netty.NettyChannelAdapter;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientHandler
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(NettyClientHandler.class);
    private RemotingDataProcessor remotingDataProcessor;
    private NettyChannelAdapter channelAdapter;

    public NettyClientHandler(RemotingDataProcessor remotingDataProcessor) {
        this.remotingDataProcessor = remotingDataProcessor;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channelAdapter = new NettyChannelAdapter(ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.remotingDataProcessor.support(msg)) {
            this.remotingDataProcessor.readMessage((Channel)this.channelAdapter, msg, (Object)ctx);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if ((msg = this.remotingDataProcessor.writeMessage((Channel)this.channelAdapter, msg, (Object)ctx)) != null) {
            super.write(ctx, msg, promise);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
        super.exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            Request req = new Request();
            req.setHeartbeat(true);
            ctx.writeAndFlush((Object)req);
            this.remotingDataProcessor.sendHeartbeat((Channel)this.channelAdapter, (Object)ctx);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

