/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.api;

import cloud.tianai.remoting.api.Header;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class Request
extends Header
implements Serializable {
    private static final AtomicLong INVOKE_ID = new AtomicLong(0L);
    private long id = Request.newId();
    private String version;
    private Object[] requestParam;
    private String methodName;
    private Class<?> interfaceType;
    private Class<?> returnType;
    private boolean heartbeat;

    public static Request copyRequest(Request request) {
        Request result = new Request();
        result.setId(request.getId());
        result.setVersion(request.getVersion());
        result.setRequestParam(request.getRequestParam());
        result.setMethodName(request.getMethodName());
        result.setInterfaceType(request.getInterfaceType());
        result.setReturnType(request.getReturnType());
        result.setHeartbeat(request.isHeartbeat());
        return result;
    }

    private static long newId() {
        return INVOKE_ID.getAndIncrement();
    }

    public long getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Object[] getRequestParam() {
        return this.requestParam;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getInterfaceType() {
        return this.interfaceType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public boolean isHeartbeat() {
        return this.heartbeat;
    }

    public Request setId(long id) {
        this.id = id;
        return this;
    }

    public Request setVersion(String version) {
        this.version = version;
        return this;
    }

    public Request setRequestParam(Object[] requestParam) {
        this.requestParam = requestParam;
        return this;
    }

    public Request setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public Request setInterfaceType(Class<?> interfaceType) {
        this.interfaceType = interfaceType;
        return this;
    }

    public Request setReturnType(Class<?> returnType) {
        this.returnType = returnType;
        return this;
    }

    public Request setHeartbeat(boolean heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRequestParam(), other.getRequestParam())) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        Class<?> this$interfaceType = this.getInterfaceType();
        Class<?> other$interfaceType = other.getInterfaceType();
        if (this$interfaceType == null ? other$interfaceType != null : !this$interfaceType.equals(other$interfaceType)) {
            return false;
        }
        Class<?> this$returnType = this.getReturnType();
        Class<?> other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        return this.isHeartbeat() == other.isHeartbeat();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRequestParam());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        Class<?> $interfaceType = this.getInterfaceType();
        result = result * 59 + ($interfaceType == null ? 43 : $interfaceType.hashCode());
        Class<?> $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        result = result * 59 + (this.isHeartbeat() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Request(super=" + super.toString() + ", id=" + this.getId() + ", version=" + this.getVersion() + ", requestParam=" + Arrays.deepToString(this.getRequestParam()) + ", methodName=" + this.getMethodName() + ", interfaceType=" + this.getInterfaceType() + ", returnType=" + this.getReturnType() + ", heartbeat=" + this.isHeartbeat() + ")";
    }
}

