/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.api;

import cloud.tianai.remoting.api.RemotingChannelHolder;
import cloud.tianai.remoting.api.RemotingConfiguration;
import cloud.tianai.remoting.api.RemotingEndpoint;
import cloud.tianai.remoting.api.exception.RpcRemotingException;
import cloud.tianai.rpc.common.util.id.IdUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemotingEndpoint
implements RemotingEndpoint {
    private static final Logger log = LoggerFactory.getLogger(AbstractRemotingEndpoint.class);
    private AtomicBoolean start = new AtomicBoolean(false);
    private String id;
    private int weight = 100;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RemotingChannelHolder start(RemotingConfiguration config) throws RpcRemotingException {
        if (!this.start.compareAndSet(false, true)) {
            throw new RpcRemotingException("\u65e0\u9700\u91cd\u590d\u542f\u52a8");
        }
        this.id = IdUtils.getNoRepetitionIdStr();
        try {
            RemotingChannelHolder channelHolder = this.doStart(config);
            return channelHolder;
        }
        catch (RpcRemotingException e) {
            this.start.set(false);
            throw e;
        }
        catch (Exception e) {
            this.start.set(false);
            throw new RpcRemotingException(e);
        }
    }

    @Override
    public void stop() {
        if (this.start.compareAndSet(true, false)) {
            try {
                this.doStop();
            }
            catch (Throwable e) {
                log.warn("\u505c\u6b62server\u5931\u8d25 , \u7c7b\u578b[{}], e: [{}]", (Object)this.getRemotingType(), (Object)e);
            }
        }
    }

    @Override
    public boolean isStart() {
        return this.start.get();
    }

    @Override
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    protected abstract RemotingChannelHolder doStart(RemotingConfiguration var1) throws RpcRemotingException;

    protected abstract void doStop() throws RpcRemotingException;
}

