/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.api;

import cloud.tianai.remoting.api.Channel;
import cloud.tianai.remoting.api.DefaultFuture;
import cloud.tianai.remoting.api.RemotingDataProcessor;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.Response;
import cloud.tianai.remoting.api.RpcInvocation;
import cloud.tianai.remoting.api.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResponseRemotingDataProcessor
implements RemotingDataProcessor {
    private static final Logger log = LoggerFactory.getLogger(RequestResponseRemotingDataProcessor.class);
    private RpcInvocation rpcInvocation;

    public RequestResponseRemotingDataProcessor(RpcInvocation rpcInvocation) {
        this.rpcInvocation = rpcInvocation;
    }

    @Override
    public void readMessage(Channel channel, Object msg, Object extend) {
        if (msg instanceof Request) {
            Response response = this.rpcInvocation.invoke((Request)msg);
            channel.write(response);
        } else {
            DefaultFuture.received(channel, (Response)msg, true);
        }
    }

    @Override
    public Object writeMessage(Channel channel, Object msg, Object extend) {
        if (this.support(msg)) {
            return msg;
        }
        Response response = null;
        if (msg instanceof Throwable) {
            response = this.processThrowable((Throwable)msg, extend);
        }
        return response;
    }

    private Response processThrowable(Throwable ex, Object data) {
        Response response = null;
        if (data instanceof Request) {
            response = ResponseUtils.warpResponse(ex, (Request)data);
        } else if (data instanceof Response) {
            response = ResponseUtils.warpResponse(ex, (Response)data);
        }
        return response;
    }

    @Override
    public void sendHeartbeat(Channel channel, Object extend) {
        Request request = new Request();
        request.setHeartbeat(true);
        channel.write(request);
    }

    @Override
    public void sendError(Channel channel, Throwable ex, Object data) {
        Response response = null;
        if (data instanceof Request) {
            response = ResponseUtils.warpResponse(ex, (Request)data);
        } else if (data instanceof Response) {
            response = ResponseUtils.warpResponse(ex, (Response)data);
        } else {
            log.error("\u53d1\u9001\u5f02\u5e38\u4fe1\u606f\u5931\u8d25, \u53c2\u6570\u4e0d\u652f\u6301\uff0c data={}, ex={}", data, (Object)ex);
        }
        ex.printStackTrace();
        if (response != null) {
            channel.write(response);
        }
    }

    @Override
    public boolean support(Object msg) {
        return msg instanceof Request || msg instanceof Response;
    }
}

