/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.api;

import cloud.tianai.remoting.api.Channel;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.Response;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFuture
extends CompletableFuture<Object> {
    private static final Logger log = LoggerFactory.getLogger(DefaultFuture.class);
    private static final Map<Long, Channel> CHANNELS = new ConcurrentHashMap<Long, Channel>();
    private static final Map<Long, DefaultFuture> FUTURES = new ConcurrentHashMap<Long, DefaultFuture>();
    private ExecutorService executor;
    private final Long id;
    private final Channel channel;
    private final Request request;
    private final int timeout;
    private final long start = System.currentTimeMillis();
    private volatile long sent;

    private DefaultFuture(Channel channel, Request request, int timeout) {
        this.channel = channel;
        this.request = request;
        this.id = request.getId();
        this.timeout = timeout;
        FUTURES.put(this.id, this);
        CHANNELS.put(this.id, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void received(Channel channel, Response response, boolean timeout) {
        try {
            DefaultFuture future;
            String errorMessage;
            Long id = response.getId();
            if (Objects.isNull(id) && StringUtils.isNotBlank((CharSequence)(errorMessage = response.getErrorMessage()))) {
                if (log.isErrorEnabled()) {
                    log.error("TIANAI-RPC \u63a5\u53d7\u5230\u6570\u636e\uff0c id\u4e3a\u7a7a\uff0c \u5f02\u5e38\u4fe1\u606f\u4e3a: {}", (Object)errorMessage);
                } else {
                    System.out.println("TIANAI-RPC \u63a5\u53d7\u5230\u6570\u636e\uff0c id\u4e3a\u7a7a\uff0c \u5f02\u5e38\u4fe1\u606f\u4e3a:" + errorMessage);
                }
            }
            if ((future = FUTURES.remove(id)) != null) {
                future.doReceived(response);
            } else if (response.isHeartbeat()) {
                log.debug("\u8fdc\u7a0b\u5730\u5740[" + channel.getRemoteAddress() + "]  -> \u5fc3\u8df3\u8bf7\u6c42\u8fd4\u56de.");
            } else {
                log.warn("The timeout response finally returned at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + ", response " + response + (channel == null ? "" : ", channel: " + channel.getLocalAddress() + " -> " + channel.getRemoteAddress()));
            }
        }
        finally {
            CHANNELS.remove(response.getId());
        }
    }

    private void doReceived(Response res) {
        if (res == null) {
            throw new IllegalStateException("response cannot be null");
        }
        this.complete(res);
    }

    public static DefaultFuture newFuture(Channel channel, Request request, int timeout) {
        DefaultFuture future = new DefaultFuture(channel, request, timeout);
        return future;
    }

    public static DefaultFuture newFuture(Channel channel, Request request, int timeout, ExecutorService executor) {
        DefaultFuture future = new DefaultFuture(channel, request, timeout);
        future.setExecutor(executor);
        return future;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Long getId() {
        return this.id;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Request getRequest() {
        return this.request;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getStart() {
        return this.start;
    }

    public long getSent() {
        return this.sent;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setSent(long sent) {
        this.sent = sent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultFuture)) {
            return false;
        }
        DefaultFuture other = (DefaultFuture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        Request this$request = this.getRequest();
        Request other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        return this.getSent() == other.getSent();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultFuture;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        Request $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        result = result * 59 + this.getTimeout();
        long $start = this.getStart();
        result = result * 59 + (int)($start >>> 32 ^ $start);
        long $sent = this.getSent();
        result = result * 59 + (int)($sent >>> 32 ^ $sent);
        return result;
    }

    @Override
    public String toString() {
        return "DefaultFuture(executor=" + this.getExecutor() + ", id=" + this.getId() + ", channel=" + this.getChannel() + ", request=" + this.getRequest() + ", timeout=" + this.getTimeout() + ", start=" + this.getStart() + ", sent=" + this.getSent() + ")";
    }
}

