/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.remoting.api;

import cloud.tianai.remoting.api.HighRpcInvocation;
import cloud.tianai.remoting.api.Request;
import cloud.tianai.remoting.api.Response;
import cloud.tianai.remoting.api.RpcInvocationPostProcessor;
import cloud.tianai.remoting.api.util.ResponseUtils;
import cloud.tianai.rpc.common.exception.RpcException;
import cloud.tianai.rpc.common.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractHignRpcInvocation
implements HighRpcInvocation {
    public static final String HEARTBEAT_RESULT = "heartbeat success";
    private Map<Class<?>, Object> objectMap = new ConcurrentHashMap(256);
    private List<RpcInvocationPostProcessor> postProcessors = new ArrayList<RpcInvocationPostProcessor>(8);

    @Override
    public void putInvokeObj(Class<?> interfaceClass, Object ref) {
        this.objectMap.remove(interfaceClass);
        this.objectMap.put(interfaceClass, ref);
    }

    @Override
    public void addPostProcessor(RpcInvocationPostProcessor postProcessor) {
        this.postProcessors.remove(postProcessor);
        this.postProcessors.add(postProcessor);
    }

    @Override
    public Response invoke(Request request) {
        Response response;
        if (Objects.isNull(request)) {
            throw new RpcException("rpc\u8c03\u7528\u5f02\u5e38, \u53c2\u6570[request] \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.isHeartbeat()) {
            String invokeResult = HEARTBEAT_RESULT;
            response = ResponseUtils.warpResponse(invokeResult, request);
        } else {
            Object invokeObj = this.getInvokeObj(request);
            String methodName = request.getMethodName();
            Object[] requestParam = request.getRequestParam();
            Class[] requestParamType = ClassUtils.getType((Object[])requestParam);
            Method method = null;
            try {
                method = invokeObj.getClass().getMethod(methodName, requestParamType);
                response = this.beforeInvoke(method, request, invokeObj);
                if (response == null) {
                    Object invokeResult = this.doInvoke(method, invokeObj, request);
                    response = ResponseUtils.warpResponse(invokeResult, request);
                    response = this.invokeFinished(request, response, method, invokeObj);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                response = ResponseUtils.warpResponse(e, request);
                response = this.invokeError(request, response, method, invokeObj, e);
            }
        }
        return response;
    }

    protected Object getInvokeObj(Request request) {
        Class<?> interfaceType = request.getInterfaceType();
        Object invokeObj = this.objectMap.get(interfaceType);
        if (Objects.isNull(invokeObj)) {
            throw new RpcException("rpc\u8c03\u7528\u5f02\u5e38, \u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f8b[" + interfaceType + "]");
        }
        return invokeObj;
    }

    protected Response invokeError(Request request, Response response, Method method, Object invokeObj, Throwable e) {
        for (RpcInvocationPostProcessor postProcessor : this.postProcessors) {
            response = postProcessor.invokeError(request, response, method, invokeObj, e);
        }
        return response;
    }

    protected Response invokeFinished(Request request, Response response, Method method, Object invokeObj) {
        for (RpcInvocationPostProcessor postProcessor : this.postProcessors) {
            response = postProcessor.invokeFinished(request, response, method, invokeObj);
        }
        return response;
    }

    protected Response beforeInvoke(Method method, Request request, Object invokeObj) {
        RpcInvocationPostProcessor postProcessor;
        Response response = null;
        Iterator<RpcInvocationPostProcessor> iterator = this.postProcessors.iterator();
        while (iterator.hasNext() && (response = (postProcessor = iterator.next()).beforeInvoke(method, request, invokeObj)) == null) {
        }
        return response;
    }

    protected abstract Object doInvoke(Method var1, Object var2, Request var3) throws Exception;
}

