/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.rpc.remoting.codec.protostuff;

import cloud.tianai.rpc.remoting.codec.api.RemotingDataEncoder;
import cloud.tianai.rpc.remoting.codec.api.exception.CodecException;
import cloud.tianai.rpc.remoting.codec.protostuff.Wrapper;
import cloud.tianai.rpc.remoting.codec.protostuff.utils.WrapperUtils;
import io.protostuff.GraphIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ProtostuffEncoder
implements RemotingDataEncoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(Object obj) {
        byte[] classNameBytes;
        byte[] bytes;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        LinkedBuffer buffer = LinkedBuffer.allocate();
        try {
            Schema schema;
            if (obj == null || WrapperUtils.needWrapper(obj)) {
                schema = RuntimeSchema.getSchema(Wrapper.class);
                Wrapper<Object> wrapper = new Wrapper<Object>(obj);
                bytes = GraphIOUtil.toByteArray(wrapper, (Schema)schema, (LinkedBuffer)buffer);
                classNameBytes = Wrapper.class.getName().getBytes();
            } else {
                schema = RuntimeSchema.getSchema(obj.getClass());
                bytes = GraphIOUtil.toByteArray((Object)obj, (Schema)schema, (LinkedBuffer)buffer);
                classNameBytes = obj.getClass().getName().getBytes();
            }
        }
        finally {
            buffer.clear();
        }
        try {
            byte[] result;
            dos.writeInt(classNameBytes.length);
            dos.writeInt(bytes.length);
            dos.write(classNameBytes);
            dos.write(bytes);
            byte[] byArray = result = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new CodecException((Throwable)e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }
}

