/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.stream;

import cloud.tianai.crypto.exception.CryptoException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SdkFilterOutputStream
extends FilterOutputStream {
    private volatile boolean aborted = false;

    public SdkFilterOutputStream(OutputStream out) {
        super(out);
    }

    public OutputStream getDelegateStream() {
        return this.out;
    }

    protected final void abortIfNeeded() {
        if (SdkFilterOutputStream.shouldAbort()) {
            this.abort();
            throw new CryptoException("Thread aborted, inputStream aborted...");
        }
    }

    public void abort() {
        if (this.out instanceof SdkFilterOutputStream) {
            ((SdkFilterOutputStream)this.out).abort();
        }
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void write(int b) throws IOException {
        this.abortIfNeeded();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.abortIfNeeded();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.abortIfNeeded();
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.abortIfNeeded();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.abortIfNeeded();
    }

    public static boolean shouldAbort() {
        return Thread.interrupted();
    }
}

