/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.stream;

import cloud.tianai.crypto.cipher.core.CryptoCipher;
import cloud.tianai.crypto.stream.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherInputStream
extends SdkFilterInputStream {
    private static final Logger log = LoggerFactory.getLogger(CipherInputStream.class);
    private static final int MAX_RETRY = 1000;
    private static final int DEFAULT_IN_BUFFER_SIZE = 4096;
    public static final int POSITIVE_MULTIPLE = 64;
    private final AtomicBoolean firstRead = new AtomicBoolean(false);
    private CryptoCipher cryptoCipher;
    private boolean hasBeenAccessed;
    private byte[] bufIn;
    private int bufferSize;
    private boolean eof;
    private byte[] bufOut;
    private int currPos;
    private int maxPos;

    public CipherInputStream(InputStream is, CryptoCipher cryptoCipher) {
        this(is, cryptoCipher, 4096);
    }

    public CipherInputStream(InputStream is, CryptoCipher c, int buffSize) {
        super(is);
        this.cryptoCipher = c;
        this.bufferSize = buffSize;
    }

    public int getBuffSize() {
        return this.bufferSize;
    }

    public void setBuffSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public byte[] getBufIn() {
        if (this.bufIn == null) {
            this.bufIn = new byte[this.bufferSize];
        }
        return this.bufIn;
    }

    public void setBufIn(byte[] bufIn) {
        this.bufIn = bufIn;
    }

    public int earlyEncryptGetHeaderSize() {
        byte[] headerData = this.cryptoCipher.earlyLoadingHeaderData(this);
        return headerData != null ? headerData.length : 0;
    }

    @Override
    public int read() throws IOException {
        this.hasBeenAccessed = true;
        if (this.readChunkIfNecessary() == -1) {
            return -1;
        }
        return this.bufOut[this.currPos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] buf, int off, int targetLen) throws IOException {
        this.hasBeenAccessed = true;
        if (this.readChunkIfNecessary() == -1) {
            return -1;
        }
        if (targetLen <= 0) {
            return 0;
        }
        int len = this.maxPos - this.currPos;
        if (targetLen < len) {
            len = targetLen;
        }
        System.arraycopy(this.bufOut, this.currPos, buf, off, len);
        this.currPos += len;
        return len;
    }

    protected int readChunkIfNecessary() throws IOException {
        int len = 0;
        if (this.currPos >= this.maxPos) {
            if (this.eof) {
                return -1;
            }
            int count = 0;
            do {
                if (count > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                len = this.nextChunk();
                ++count;
            } while (len == 0);
        }
        return len;
    }

    @Override
    public long skip(long n) {
        this.abortIfNeeded();
        this.hasBeenAccessed = true;
        int available = this.maxPos - this.currPos;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.currPos = (int)((long)this.currPos + n);
        return n;
    }

    @Override
    public int available() {
        this.abortIfNeeded();
        return this.maxPos - this.currPos;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        try {
            this.cryptoCipher.end();
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            log.warn("cryptoCipher.end() warn", (Throwable)ex);
        }
        this.maxPos = 0;
        this.currPos = 0;
        this.abortIfNeeded();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }

    @Override
    public void mark(int readLimit) {
        if (this.hasBeenAccessed) {
            throw new UnsupportedOperationException("Marking is only supported before your first call to read or skip.");
        }
        this.in.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
        this.resetInternal();
    }

    final void resetInternal() {
        this.maxPos = 0;
        this.currPos = 0;
        this.eof = false;
        this.hasBeenAccessed = false;
        this.firstRead.set(false);
        this.cryptoCipher = this.cryptoCipher.recreate();
    }

    protected int nextChunk() throws IOException {
        byte[] bufIn;
        int len;
        this.abortIfNeeded();
        if (this.eof) {
            return -1;
        }
        this.bufOut = null;
        if (this.firstRead.compareAndSet(false, true)) {
            this.bufOut = this.cryptoCipher.start(this);
            if (this.bufOut != null && this.bufOut.length > 0) {
                this.currPos = 0;
                this.maxPos = this.bufOut.length;
                return this.maxPos;
            }
        }
        if ((len = this.in.read(bufIn = this.getBufIn())) == -1) {
            this.eof = true;
            try {
                this.bufOut = this.cryptoCipher.end();
                if (this.bufOut == null) {
                    return -1;
                }
                this.currPos = 0;
                this.maxPos = this.bufOut.length;
                return this.maxPos;
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
            }
            catch (BadPaddingException e) {
                throw new SecurityException(e);
            }
            return -1;
        }
        this.bufOut = this.cryptoCipher.update(bufIn, 0, len);
        this.currPos = 0;
        this.maxPos = this.bufOut == null ? 0 : this.bufOut.length;
        return this.maxPos;
    }
}

