/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.cipher.util;

import cloud.tianai.crypto.cipher.util.CryptoRuntime;
import cloud.tianai.crypto.exception.CryptoCipherException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;

public class RsaUtils {
    public static final String KEY_WRAP_ALGORITHM = "RSA/NONE/PKCS1Padding";

    public static byte[] encrypt(Key key, byte[] data) {
        Cipher cipher = Cipher.getInstance(KEY_WRAP_ALGORITHM);
        cipher.init(1, key, new SecureRandom());
        byte[] encryptBytes = cipher.doFinal(data);
        return encryptBytes;
    }

    public static byte[] decrypt(Key key, byte[] encryptedData) {
        Cipher cipher = Cipher.getInstance(KEY_WRAP_ALGORITHM);
        cipher.init(2, key);
        byte[] decryptData = cipher.doFinal(encryptedData);
        return decryptData;
    }

    public static RSAPublicKey getPublicKeyFromPemX509(String publicKeyStr) {
        try {
            String adjustStr = StringUtils.replace((String)publicKeyStr, (String)"-----BEGIN PUBLIC KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----BEGIN RSA PUBLIC KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----END PUBLIC KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----END RSA PUBLIC KEY-----", (String)"");
            adjustStr = adjustStr.replace("\n", "");
            adjustStr = adjustStr.replace("\r", "");
            byte[] buffer = Base64.getDecoder().decode(adjustStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new CryptoCipherException("Get public key from X509 pem String error." + e.getMessage(), e);
        }
    }

    public static RSAPrivateKey getPrivateKeyFromPemPKCS8(String privateKeyStr) {
        try {
            String adjustStr = StringUtils.replace((String)privateKeyStr, (String)"-----BEGIN PRIVATE KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----BEGIN RSA PRIVATE KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----END PRIVATE KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----END RSA PRIVATE KEY-----", (String)"");
            adjustStr = adjustStr.replace("\n", "");
            adjustStr = adjustStr.replace("\r", "");
            byte[] buffer = Base64.getDecoder().decode(adjustStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new CryptoCipherException("Get private key from PKCS8 pem String error: " + e.getMessage(), e);
        }
    }

    public static RSAPrivateKey getPrivateKeyFromPemPKCS1(String privateKeyStr) {
        try {
            String adjustStr = StringUtils.replace((String)privateKeyStr, (String)"-----BEGIN PRIVATE KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----BEGIN RSA PRIVATE KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----END PRIVATE KEY-----", (String)"");
            adjustStr = StringUtils.replace((String)adjustStr, (String)"-----END RSA PRIVATE KEY-----", (String)"");
            adjustStr = adjustStr.replace("\n", "");
            adjustStr = adjustStr.replace("\r", "");
            CryptoRuntime.enableBouncyCastle();
            byte[] buffer = Base64.getDecoder().decode(adjustStr);
            RSAPrivateKeySpec keySpec = CryptoRuntime.convertPemPKCS1ToPrivateKey(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new CryptoCipherException("get private key from PKCS1 pem String error." + e.getMessage(), e);
        }
    }

    public static String[] genKeyPair(int keySize) {
        byte[][] keyPairBytes = RsaUtils.genKeyPairBytes(keySize);
        String[] keyPairs = new String[]{Base64.getEncoder().encodeToString(keyPairBytes[0]), Base64.getEncoder().encodeToString(keyPairBytes[1])};
        return keyPairs;
    }

    public static byte[][] genKeyPairBytes(int keySize) {
        byte[][] keyPairBytes = new byte[2][];
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", "SunRsaSign");
            gen.initialize(keySize, new SecureRandom());
            KeyPair pair = gen.generateKeyPair();
            keyPairBytes[0] = pair.getPrivate().getEncoded();
            keyPairBytes[1] = pair.getPublic().getEncoded();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        return keyPairBytes;
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

