/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.cipher.core.impl;

import cloud.tianai.crypto.cipher.core.CryptoCipher;
import cloud.tianai.crypto.stream.CipherInputStream;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class Base64CryptoCipher
implements CryptoCipher {
    private int model;
    private int bufferSize;

    public Base64CryptoCipher(int model) {
        this(model, 4096);
    }

    public Base64CryptoCipher(int model, int bufferSize) {
        this.model = model;
        this.bufferSize = bufferSize;
    }

    @Override
    public int getModel() {
        return this.model;
    }

    @Override
    public byte[] end() throws IllegalBlockSizeException, BadPaddingException {
        return new byte[0];
    }

    @Override
    public byte[] update(byte[] input, int inputOffset, int inputLen) {
        return this.transcode(input, inputOffset, inputLen);
    }

    @Override
    public byte[] earlyLoadingHeaderData(CipherInputStream source) {
        int length = this.calcLength();
        if (source.getBuffSize() != length) {
            source.setBuffSize(length);
        }
        return new byte[0];
    }

    @Override
    public byte[] start(CipherInputStream source) {
        int length = this.calcLength();
        if (source.getBuffSize() != length) {
            source.setBuffSize(length);
        }
        return new byte[0];
    }

    @Override
    public CryptoCipher recreate() {
        return new Base64CryptoCipher(this.model);
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public byte[] start(byte[] b, int off, int len) {
        return new byte[0];
    }

    public byte[] transcode(byte[] source, int offset, int length) {
        byte[] input = new byte[length];
        System.arraycopy(source, offset, input, 0, length);
        if (this.model == 1) {
            return Base64.getEncoder().encode(input);
        }
        return Base64.getDecoder().decode(input);
    }

    public int calcLength() {
        return 1 == this.model ? this.bufferSize : 4 * ((this.bufferSize + 2) / 3);
    }
}

