/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.cipher.core;

import cloud.tianai.crypto.cipher.core.CryptoCipher;
import cloud.tianai.crypto.stream.CipherInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class SimpleCryptoCipher
implements CryptoCipher {
    protected Cipher cipher;
    protected int model;

    public SimpleCryptoCipher(Cipher cipher, int model) {
        this.cipher = cipher;
        this.model = model;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    @Override
    public int getModel() {
        return this.model;
    }

    @Override
    public byte[] end() throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal();
    }

    @Override
    public byte[] update(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }

    @Override
    public byte[] earlyLoadingHeaderData(CipherInputStream source) {
        return new byte[0];
    }

    @Override
    public byte[] start(CipherInputStream source) {
        return null;
    }

    @Override
    public CryptoCipher recreate() {
        return new SimpleCryptoCipher(this.cipher, this.model);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public byte[] start(byte[] b, int off, int len) {
        return null;
    }
}

