/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.check.impl;

import cloud.tianai.crypto.check.EnhanceChecksum;
import java.security.MessageDigest;

public class DigestChecksum
implements EnhanceChecksum<byte[]> {
    protected MessageDigest messageDigest;
    protected String algorithm;

    public DigestChecksum(String algorithm) {
        this.algorithm = algorithm;
        this.createMessageDigest();
    }

    private void createMessageDigest() {
        this.messageDigest = MessageDigest.getInstance(this.algorithm);
    }

    @Override
    public byte[] getCheckValue() {
        return this.messageDigest.digest();
    }

    @Override
    public void update(int b) {
        this.messageDigest.update(Integer.valueOf(b).byteValue());
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.messageDigest.update(b, off, len);
    }

    @Override
    public void reset() {
        this.createMessageDigest();
    }
}

