/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.stream;

import cloud.tianai.crypto.check.EnhanceChecksum;
import cloud.tianai.crypto.check.impl.ChecksumAdapter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class EnhanceCheckedOutputStream
extends FilterOutputStream {
    private EnhanceChecksum cksum;

    public EnhanceCheckedOutputStream(OutputStream out, Checksum cksum) {
        super(out);
        this.cksum = cksum instanceof EnhanceChecksum ? (EnhanceChecksum)cksum : new ChecksumAdapter(cksum);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.cksum.update(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.cksum.update(b, off, len);
    }

    public <R> EnhanceChecksum<R> getChecksum() {
        return this.cksum;
    }
}

