/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.stream;

import cloud.tianai.crypto.check.EnhanceChecksum;
import cloud.tianai.crypto.check.impl.ChecksumAdapter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class EnhanceCheckedInputStream
extends FilterInputStream {
    private EnhanceChecksum cksum;

    public EnhanceCheckedInputStream(InputStream in, Checksum cksum) {
        super(in);
        this.cksum = cksum instanceof EnhanceChecksum ? (EnhanceChecksum)cksum : new ChecksumAdapter(cksum);
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.cksum.update(b);
        }
        return b;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if ((len = this.in.read(buf, off, len)) != -1) {
            this.cksum.update(buf, off, len);
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        long total;
        long len;
        byte[] buf = new byte[512];
        for (total = 0L; total < n; total += len) {
            len = n - total;
            len = this.read(buf, 0, len < (long)buf.length ? (int)len : buf.length);
            if (len != -1L) continue;
            return total;
        }
        return total;
    }

    public <R> EnhanceChecksum<R> getChecksum() {
        return this.cksum;
    }
}

