/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.stream;

import cloud.tianai.crypto.cipher.core.CryptoCipher;
import cloud.tianai.crypto.stream.SdkFilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherOutputStream
extends SdkFilterOutputStream {
    private static final Logger log = LoggerFactory.getLogger(CipherOutputStream.class);
    private final AtomicBoolean firstRead = new AtomicBoolean(false);
    private CryptoCipher cryptoCipher;

    public CipherOutputStream(OutputStream os, CryptoCipher c) {
        super(os);
        this.cryptoCipher = c;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.write(bytes, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] start;
        if (this.firstRead.compareAndSet(false, true) && (start = this.cryptoCipher.start(b, off, len)) != null && start.length > 0) {
            this.out.write(start);
        }
        byte[] update = this.cryptoCipher.update(b, off, len);
        this.out.write(update);
    }

    @Override
    public void close() throws IOException {
        try {
            byte[] end = this.cryptoCipher.end();
            if (end != null && end.length > 0) {
                this.out.write(end);
            }
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            log.warn("cryptoCipher.end() warn", (Throwable)ex);
        }
        this.out.close();
    }
}

