/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.cipher.core.impl;

import cloud.tianai.crypto.cipher.core.AbstractCryptoCipher;
import cloud.tianai.crypto.cipher.core.CryptoCipher;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm4CryptoCipher
extends AbstractCryptoCipher {
    private static final Logger log = LoggerFactory.getLogger(Sm4CryptoCipher.class);
    public static final String CONTENT_CIPHER_ALGORITHM = "SM4/CTR/NoPadding";
    public static final String KEY_GENERATOR_ALGORITHM = "SM4";
    public static final int KEY_LENGTH_IN_BITS = 128;
    public static final int CIPHER_IV_LENGTH = 16;
    private static final SecureRandom RANDOM = new SecureRandom();
    public int version = 1;
    boolean skipCheckVersion;

    public Sm4CryptoCipher(Cipher cipher, int model) {
        this(cipher, model, false);
    }

    public Sm4CryptoCipher(Cipher cipher, int model, boolean skipCheckVersion) {
        super(cipher, model);
        this.skipCheckVersion = skipCheckVersion;
    }

    public Sm4CryptoCipher(Cipher cipher, int model, boolean skipCheckVersion, int version) {
        super(cipher, model);
        this.skipCheckVersion = skipCheckVersion;
        this.version = version;
    }

    @Override
    protected boolean skipCheckVersion() {
        return this.skipCheckVersion;
    }

    @Override
    public CryptoCipher recreate() {
        return new Sm4CryptoCipher(this.getCipher(), this.getModel());
    }

    @Override
    public String getAlgorithm() {
        return KEY_GENERATOR_ALGORITHM;
    }

    @Override
    public String getContentCipherAlgorithm() {
        return CONTENT_CIPHER_ALGORITHM;
    }

    @Override
    public int getKeyLength() {
        return 128;
    }

    @Override
    public int getIvLength() {
        return 16;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

