/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.cipher.core.impl;

import cloud.tianai.crypto.cipher.core.AbstractCryptoCipher;
import cloud.tianai.crypto.cipher.core.CryptoCipher;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesCryptoCipher
extends AbstractCryptoCipher {
    private static final Logger log = LoggerFactory.getLogger(AesCryptoCipher.class);
    public static final String CONTENT_CIPHER_ALGORITHM = "AES/CTR/NoPadding";
    public static final String KEY_GENERATOR_ALGORITHM = "AES";
    public static final int KEY_LENGTH_IN_BITS = 256;
    public static final int CIPHER_IV_LENGTH = 16;
    private static final SecureRandom RANDOM = new SecureRandom();
    public int version = 1;
    boolean skipCheckVersion;

    public AesCryptoCipher(Cipher cipher, int model) {
        this(cipher, model, false);
    }

    public AesCryptoCipher(Cipher cipher, int model, boolean checkVersion) {
        super(cipher, model);
        this.skipCheckVersion = checkVersion;
    }

    public AesCryptoCipher(Cipher cipher, int model, boolean skipCheckVersion, int version) {
        super(cipher, model);
        this.skipCheckVersion = skipCheckVersion;
        this.version = version;
    }

    @Override
    protected boolean skipCheckVersion() {
        return this.skipCheckVersion;
    }

    @Override
    public String getAlgorithm() {
        return KEY_GENERATOR_ALGORITHM;
    }

    @Override
    public String getContentCipherAlgorithm() {
        return CONTENT_CIPHER_ALGORITHM;
    }

    @Override
    public int getKeyLength() {
        return 256;
    }

    @Override
    public int getIvLength() {
        return 16;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    protected SecureRandom getRandom() {
        return RANDOM;
    }

    @Override
    public CryptoCipher recreate() {
        return new AesCryptoCipher(this.getCipher(), this.getModel());
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

