/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.cipher.core;

import cloud.tianai.crypto.cipher.core.SimpleCryptoCipher;
import cloud.tianai.crypto.exception.CryptoCipherException;
import cloud.tianai.crypto.stream.CipherInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCryptoCipher
extends SimpleCryptoCipher {
    private static final Logger log = LoggerFactory.getLogger(AbstractCryptoCipher.class);
    byte[] iv;
    SecretKey secretKey;
    EncryptData encryptData;
    Cipher internalCipher;
    byte[] headerData;
    private ByteArrayOutputStream beforeInputData = new ByteArrayOutputStream();

    public AbstractCryptoCipher(Cipher cipher, int model) {
        super(cipher, model);
    }

    @Override
    public byte[] update(byte[] input, int inputOffset, int inputLen) {
        if (this.internalCipher != null) {
            return this.internalCipher.update(input, inputOffset, inputLen);
        }
        this.beforeInputData.write(input, inputOffset, inputLen);
        byte[] headerBytes = this.beforeInputData.toByteArray();
        ByteArrayInputStream headerInputStream = new ByteArrayInputStream(headerBytes);
        this.tryInitCipher(headerInputStream);
        if (this.internalCipher == null) {
            return new byte[0];
        }
        this.beforeInputData.close();
        int useLength = headerBytes.length - headerInputStream.available();
        if (useLength == headerBytes.length) {
            return new byte[0];
        }
        if (this.headerData != null) {
            byte[] update = this.update(headerBytes, useLength, headerBytes.length - useLength);
            byte[] result = new byte[this.headerData.length + update.length];
            System.arraycopy(this.headerData, 0, result, 0, this.headerData.length);
            System.arraycopy(update, 0, result, this.headerData.length, update.length);
            this.headerData = null;
            return result;
        }
        return this.update(headerBytes, useLength, headerBytes.length - useLength);
    }

    protected void tryInitCipher(InputStream inputStream) {
        if (1 == this.getModel()) {
            this.initEncryptCipher();
            this.headerData = this.getEncryptHeaderBytes();
        } else {
            this.encryptData = this.tryGetEncryptData(inputStream);
            if (this.encryptData != null && this.internalCipher == null) {
                this.internalCipher = this.cipher = this.createDecryptCipher();
            }
        }
    }

    private EncryptData tryGetEncryptData(InputStream inputStream) {
        byte[] encryptedCEK;
        byte[] encryptedIV;
        if (inputStream instanceof CipherInputStream) {
            inputStream = ((CipherInputStream)inputStream).getDelegateStream();
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        boolean matchVersion = this.skipCheckVersion();
        Integer version = null;
        if (!matchVersion) {
            version = dataInputStream.readInt();
            if (this.getVersion() != version.intValue()) {
                throw new CryptoCipherException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7248\u672c:" + version);
            }
        }
        try {
            int encryptIvLength = dataInputStream.readInt();
            int encryptCekLength = dataInputStream.readInt();
            encryptedIV = new byte[encryptIvLength];
            encryptedCEK = new byte[encryptCekLength];
            dataInputStream.readFully(encryptedIV);
            dataInputStream.readFully(encryptedCEK);
        }
        catch (EOFException e) {
            return null;
        }
        EncryptData encryptData = new EncryptData(encryptedIV, encryptedCEK);
        if (log.isDebugEnabled()) {
            log.debug("init AES Decrypt Cipher \r\n version:{}\r\n encryptIV:{}, \r\n encryptCEK:{}", new Object[]{version, Arrays.toString(encryptedIV), Arrays.toString(encryptedCEK)});
        }
        return encryptData;
    }

    @Override
    public byte[] end() throws IllegalBlockSizeException, BadPaddingException {
        if (this.internalCipher == null) {
            return new byte[0];
        }
        return this.internalCipher.doFinal();
    }

    @Override
    public byte[] earlyLoadingHeaderData(CipherInputStream source) {
        this.tryInitCipher(source);
        return this.headerData;
    }

    @Override
    public byte[] start(CipherInputStream source) {
        if (this.internalCipher == null) {
            this.tryInitCipher(source);
        }
        return this.headerData;
    }

    @Override
    public byte[] start(byte[] b, int off, int len) {
        return null;
    }

    protected boolean skipCheckVersion() {
        return false;
    }

    protected Cipher createDecryptCipher() {
        byte[] encryptedIV = this.encryptData.getEncryptedIV();
        byte[] encryptedCEK = this.encryptData.getEncryptedCEK();
        this.iv = this.getCipher().doFinal(encryptedIV);
        byte[] cekBytes = this.getCipher().doFinal(encryptedCEK);
        this.secretKey = new SecretKeySpec(cekBytes, this.getAlgorithm());
        return this.createCryptoCipherFromContentMaterial(this.iv, this.secretKey, this.model);
    }

    protected Cipher initEncryptCipher() {
        this.iv = this.generateIV();
        this.secretKey = this.generateCEK();
        this.internalCipher = this.createCryptoCipherFromContentMaterial(this.iv, this.secretKey, this.model);
        this.encryptData = new EncryptData();
        this.encryptData.setEncryptedIV(this.cipher.doFinal(this.iv));
        this.encryptData.setEncryptedCEK(this.cipher.doFinal(this.secretKey.getEncoded()));
        return this.internalCipher;
    }

    protected byte[] getEncryptHeaderBytes() {
        byte[] encryptedCEK = this.encryptData.getEncryptedCEK();
        byte[] encryptedIV = this.encryptData.getEncryptedIV();
        int encryptCekLength = encryptedCEK.length;
        int encryptIvLength = encryptedIV.length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(12 + encryptCekLength + encryptIvLength);
        DataOutputStream dataOutputStream = new DataOutputStream(output);
        dataOutputStream.writeInt(this.getVersion());
        dataOutputStream.writeInt(encryptedIV.length);
        dataOutputStream.writeInt(encryptedCEK.length);
        dataOutputStream.write(encryptedIV);
        dataOutputStream.write(encryptedCEK);
        if (log.isDebugEnabled()) {
            log.debug("init AES Encrypt Cipher \r\n encryptIV:{}, \r\n encryptCEK:{}", (Object)Arrays.toString(encryptedIV), (Object)Arrays.toString(encryptedCEK));
        }
        dataOutputStream.flush();
        dataOutputStream.close();
        return output.toByteArray();
    }

    public Cipher createCryptoCipherFromContentMaterial(byte[] iv, SecretKey cek, int cipherMode) {
        Cipher cipher = Cipher.getInstance(this.getContentCipherAlgorithm());
        cipher.init(cipherMode, (Key)cek, new IvParameterSpec(iv));
        return cipher;
    }

    protected SecretKey generateCEK() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(this.getAlgorithm());
            generator.init(this.getKeyLength(), this.getRandom());
            for (int retry = 0; retry < 9; ++retry) {
                SecretKey secretKey = generator.generateKey();
                if (secretKey.getEncoded()[0] == 0) continue;
                return secretKey;
            }
            throw new CryptoCipherException("Failed to generate secret key");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoCipherException("No such algorithm:" + this.getAlgorithm() + ", " + e.getMessage(), e);
        }
    }

    protected byte[] generateIV() {
        byte[] iv = new byte[this.getIvLength()];
        this.getRandom().nextBytes(iv);
        for (int i = 8; i < 12; ++i) {
            iv[i] = 0;
        }
        return iv;
    }

    protected SecureRandom getRandom() {
        return new SecureRandom();
    }

    public abstract String getAlgorithm();

    public abstract String getContentCipherAlgorithm();

    public abstract int getKeyLength();

    public abstract int getIvLength();

    public static class EncryptData {
        byte[] encryptedIV;
        byte[] encryptedCEK;

        public EncryptData() {
        }

        public EncryptData(byte[] encryptedIV, byte[] encryptedCEK) {
            this.encryptedIV = encryptedIV;
            this.encryptedCEK = encryptedCEK;
        }

        public byte[] getEncryptedIV() {
            return this.encryptedIV;
        }

        public byte[] getEncryptedCEK() {
            return this.encryptedCEK;
        }

        public void setEncryptedIV(byte[] encryptedIV) {
            this.encryptedIV = encryptedIV;
        }

        public void setEncryptedCEK(byte[] encryptedCEK) {
            this.encryptedCEK = encryptedCEK;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncryptData)) {
                return false;
            }
            EncryptData other = (EncryptData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.equals(this.getEncryptedIV(), other.getEncryptedIV())) {
                return false;
            }
            return Arrays.equals(this.getEncryptedCEK(), other.getEncryptedCEK());
        }

        protected boolean canEqual(Object other) {
            return other instanceof EncryptData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getEncryptedIV());
            result = result * 59 + Arrays.hashCode(this.getEncryptedCEK());
            return result;
        }

        public String toString() {
            return "AbstractCryptoCipher.EncryptData(encryptedIV=" + Arrays.toString(this.getEncryptedIV()) + ", encryptedCEK=" + Arrays.toString(this.getEncryptedCEK()) + ")";
        }
    }
}

