/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.crypto.cipher;

import cloud.tianai.crypto.cipher.core.CryptoCipher;
import cloud.tianai.crypto.cipher.core.impl.AesCryptoCipher;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class CryptoCipherBuilder {
    public static final String DES_CIPHER_ALGORITHM = "desede/CBC/PKCS5Padding";
    public static final String DES_KEY_ALGORITHM = "desede";
    private static final byte[] KEY_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    public static final String AES_CIPHER_ALGORITHM = "AES/CTR/NoPadding";
    public static final String AES_KEY_ALGORITHM = "AES";
    public static final String RSA_CIPHER_ALGORITHM = "RSA/NONE/PKCS1Padding";
    public static final boolean ENCRYPT = true;
    public static final boolean DECRYPT = false;

    public static CryptoCipher buildDes3Crypt(String secretKey, boolean encrypt) {
        if (StringUtils.isBlank((CharSequence)secretKey) || secretKey.length() != 24) {
            throw new IllegalArgumentException("3des\u52a0\u5bc6key\u5fc5\u987b\u4e3a24\u4f4d");
        }
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES_KEY_ALGORITHM);
        DESedeKeySpec spec = new DESedeKeySpec(secretKey.getBytes());
        SecretKey desKey = keyFactory.generateSecret(spec);
        IvParameterSpec ips = new IvParameterSpec(KEY_IV);
        Cipher cipher = Cipher.getInstance(DES_CIPHER_ALGORITHM);
        int model = encrypt ? 1 : 2;
        cipher.init(model, (Key)desKey, ips);
        return new AesCryptoCipher(cipher, model);
    }

    public static CryptoCipher buildRsaCrypt(Key key, boolean encrypt) {
        Cipher cipher = Cipher.getInstance(RSA_CIPHER_ALGORITHM);
        int model = encrypt ? 1 : 2;
        cipher.init(model, key);
        return new AesCryptoCipher(cipher, model);
    }

    public static CryptoCipher buildAesCrypt(String secretKey, boolean encrypt) {
        Cipher cipher = Cipher.getInstance(AES_CIPHER_ALGORITHM);
        SecretKeySpec keyspec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), AES_KEY_ALGORITHM);
        int model = encrypt ? 1 : 2;
        cipher.init(model, keyspec);
        return new AesCryptoCipher(cipher, model);
    }
}

