/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.autoconfiguration;

import cloud.tianai.captcha.generator.ImageCaptchaGenerator;
import cloud.tianai.captcha.generator.impl.CacheImageCaptchaGenerator;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.impl.DefaultImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.impl.DefaultResourceStore;
import cloud.tianai.captcha.spring.aop.CaptchaAdvisor;
import cloud.tianai.captcha.spring.aop.CaptchaInterceptor;
import cloud.tianai.captcha.spring.application.DefaultImageCaptchaApplication;
import cloud.tianai.captcha.spring.application.ImageCaptchaApplication;
import cloud.tianai.captcha.spring.autoconfiguration.CacheCaptchaTemplateListener;
import cloud.tianai.captcha.spring.autoconfiguration.ImageCaptchaProperties;
import cloud.tianai.captcha.spring.autoconfiguration.SliderCaptchaCacheProperties;
import cloud.tianai.captcha.spring.plugins.SpringMultiImageCaptchaGenerator;
import cloud.tianai.captcha.spring.plugins.secondary.SecondaryVerificationApplication;
import cloud.tianai.captcha.spring.store.CacheStore;
import cloud.tianai.captcha.spring.store.impl.LocalCacheStore;
import cloud.tianai.captcha.spring.store.impl.RedisCacheStore;
import cloud.tianai.captcha.validator.ImageCaptchaValidator;
import cloud.tianai.captcha.validator.impl.BasicCaptchaTrackValidator;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;

@Order
@Configuration
@EnableConfigurationProperties(value={ImageCaptchaProperties.class})
public class ImageCaptchaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ResourceStore resourceStore() {
        return new DefaultResourceStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageCaptchaResourceManager imageCaptchaResourceManager(ResourceStore resourceStore) {
        return new DefaultImageCaptchaResourceManager(resourceStore);
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageCaptchaGenerator imageCaptchaTemplate(ImageCaptchaProperties prop, ImageCaptchaResourceManager captchaResourceManager, BeanFactory beanFactory) {
        SpringMultiImageCaptchaGenerator captchaGenerator = new SpringMultiImageCaptchaGenerator(captchaResourceManager, beanFactory);
        SliderCaptchaCacheProperties cache = prop.getCache();
        if (Boolean.TRUE.equals(cache.getEnabled()) && cache.getCacheSize() > 0) {
            captchaGenerator = new CacheImageCaptchaGenerator((ImageCaptchaGenerator)captchaGenerator, cache.getCacheSize().intValue(), cache.getWaitTime().intValue(), cache.getPeriod().intValue());
        }
        captchaGenerator.init(prop.getInitDefaultResource());
        return captchaGenerator;
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageCaptchaValidator imageCaptchaValidator() {
        return new BasicCaptchaTrackValidator();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean
    public CaptchaInterceptor captchaInterceptor() {
        return new CaptchaInterceptor();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean
    public CaptchaAdvisor captchaAdvisor(CaptchaInterceptor interceptor) {
        return new CaptchaAdvisor(interceptor);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean
    public CacheCaptchaTemplateListener captchaTemplateListener() {
        return new CacheCaptchaTemplateListener();
    }

    @Bean
    @ConditionalOnMissingBean
    public ImageCaptchaApplication imageCaptchaApplication(ImageCaptchaGenerator captchaGenerator, ImageCaptchaValidator imageCaptchaValidator, CacheStore cacheStore, ImageCaptchaProperties prop) {
        ImageCaptchaApplication target = new DefaultImageCaptchaApplication(captchaGenerator, imageCaptchaValidator, cacheStore, prop);
        if (prop.getSecondary() != null && Boolean.TRUE.equals(prop.getSecondary().getEnabled())) {
            target = new SecondaryVerificationApplication(target, prop.getSecondary());
        }
        return target;
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureAfter(value={RedisCacheStoreConfiguration.class})
    @Import(value={RedisCacheStoreConfiguration.class})
    public static class LocalCacheStoreConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={CacheStore.class})
        public CacheStore local() {
            return new LocalCacheStore();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={StringRedisTemplate.class})
    @Import(value={RedisAutoConfiguration.class})
    @AutoConfigureAfter(value={RedisAutoConfiguration.class})
    public static class RedisCacheStoreConfiguration {
        @Bean
        @ConditionalOnBean(value={StringRedisTemplate.class})
        @ConditionalOnMissingBean(value={CacheStore.class})
        public CacheStore redis(StringRedisTemplate redisTemplate) {
            return new RedisCacheStore(redisTemplate);
        }
    }
}

