/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.slider;

import cloud.tianai.captcha.autoconfiguration.SliderCaptchaProperties;
import cloud.tianai.captcha.slider.AbstractSliderCaptchaApplication;
import cloud.tianai.captcha.template.slider.SliderCaptchaTemplate;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisCacheSliderCaptchaApplication
extends AbstractSliderCaptchaApplication {
    private static final RedisScript<String> SCRIPT_GET_CACHE = new DefaultRedisScript("local res = redis.call('get',KEYS[1])  if res == nil  then return nil  else  redis.call('del',KEYS[1]) return res end", String.class);
    private StringRedisTemplate redisTemplate;
    private String prefix;
    private long expire;

    public RedisCacheSliderCaptchaApplication(StringRedisTemplate redisTemplate, SliderCaptchaTemplate template, SliderCaptchaProperties prop) {
        super(template, prop);
        this.redisTemplate = redisTemplate;
        this.prefix = prop.getPrefix();
        this.expire = prop.getExpire();
    }

    @Override
    protected Float getPercentForCache(String id) {
        String key = this.getKey(id);
        String percentStr = (String)this.redisTemplate.execute(SCRIPT_GET_CACHE, Collections.singletonList(key), new Object[0]);
        if (StringUtils.isBlank((CharSequence)percentStr)) {
            return null;
        }
        return Float.valueOf(percentStr);
    }

    @Override
    protected void cacheVerification(String id, Float xPercent) {
        String key = this.getKey(id);
        this.redisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(xPercent), this.expire, TimeUnit.MILLISECONDS);
    }

    private String getKey(String id) {
        return this.prefix.concat(":").concat(id);
    }

    public static void main(String[] args) {
        StringRedisTemplate redisTemplate = new StringRedisTemplate((RedisConnectionFactory)new LettuceConnectionFactory());
        redisTemplate.afterPropertiesSet();
        redisTemplate.opsForValue().set((Object)"a", (Object)"b");
    }
}

