/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.slider;

import cloud.tianai.captcha.autoconfiguration.SliderCaptchaProperties;
import cloud.tianai.captcha.cache.ConCurrentExpiringMap;
import cloud.tianai.captcha.cache.ExpiringMap;
import cloud.tianai.captcha.slider.AbstractSliderCaptchaApplication;
import cloud.tianai.captcha.template.slider.SliderCaptchaTemplate;
import java.util.concurrent.TimeUnit;

public class LocalCacheSliderCaptchaApplication
extends AbstractSliderCaptchaApplication {
    private ExpiringMap<String, Float> cache;
    private long expire;

    public LocalCacheSliderCaptchaApplication(SliderCaptchaTemplate template, SliderCaptchaProperties prop) {
        super(template, prop);
        this.expire = prop.getExpire();
        this.cache = new ConCurrentExpiringMap<String, Float>();
        this.cache.init();
    }

    @Override
    protected Float getPercentForCache(String id) {
        Float xPercent = (Float)this.cache.remove(id);
        return xPercent;
    }

    @Override
    protected void cacheVerification(String id, Float xPercent) {
        this.cache.remove(id);
        this.cache.put(id, xPercent, this.expire, TimeUnit.MILLISECONDS);
    }
}

