/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.slider;

import cloud.tianai.captcha.autoconfiguration.SliderCaptchaProperties;
import cloud.tianai.captcha.slider.SliderCaptchaApplication;
import cloud.tianai.captcha.template.slider.SliderCaptchaInfo;
import cloud.tianai.captcha.template.slider.SliderCaptchaTemplate;
import cloud.tianai.captcha.util.Sequence;
import cloud.tianai.captcha.vo.CaptchaResponse;
import cloud.tianai.captcha.vo.SliderCaptchaVO;
import java.net.URL;
import java.util.List;
import java.util.Map;

public abstract class AbstractSliderCaptchaApplication
implements SliderCaptchaApplication {
    private SliderCaptchaTemplate template;
    private Sequence sequence = new Sequence();
    protected SliderCaptchaProperties prop;

    public AbstractSliderCaptchaApplication(SliderCaptchaTemplate template, SliderCaptchaProperties prop) {
        this.prop = prop;
        this.template = template;
    }

    @Override
    public CaptchaResponse<SliderCaptchaVO> generateSliderCaptcha() {
        SliderCaptchaInfo slideImageInfo = this.template.getSlideImageInfo();
        String id = this.generatorId();
        this.cacheVerification(id, slideImageInfo.getXPercent());
        SliderCaptchaVO verificationVO = new SliderCaptchaVO(slideImageInfo.getBackgroundImage(), slideImageInfo.getSliderImage());
        return CaptchaResponse.of(id, verificationVO);
    }

    @Override
    public boolean matching(String id, Float percentage) {
        Float cachePercentage = this.getPercentForCache(id);
        if (cachePercentage == null || cachePercentage.floatValue() < 0.0f) {
            return false;
        }
        return this.template.percentageContrast(percentage, cachePercentage);
    }

    public void addResource(URL url) {
        this.template.addResource(url);
    }

    public void addTemplate(Map<String, URL> t) {
        this.template.addTemplate(t);
    }

    public void setResource(List<URL> resources) {
        this.template.setResource(resources);
    }

    public void setTemplates(List<Map<String, URL>> imageTemplates) {
        this.template.setTemplates(imageTemplates);
    }

    public void deleteResource(URL resource) {
        this.template.deleteResource(resource);
    }

    public void deleteTemplate(Map<String, URL> t) {
        this.template.deleteTemplate(t);
    }

    private String generatorId() {
        return String.valueOf(this.sequence.nextId());
    }

    protected abstract Float getPercentForCache(String var1);

    protected abstract void cacheVerification(String var1, Float var2);
}

