/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.autoconfiguration;

import cloud.tianai.captcha.aop.CaptchaAdvisor;
import cloud.tianai.captcha.aop.CaptchaInterceptor;
import cloud.tianai.captcha.autoconfiguration.SliderCaptchaProperties;
import cloud.tianai.captcha.slider.LocalCacheSliderCaptchaApplication;
import cloud.tianai.captcha.slider.RedisCacheSliderCaptchaApplication;
import cloud.tianai.captcha.slider.SliderCaptchaApplication;
import cloud.tianai.captcha.template.slider.CacheSliderCaptchaTemplate;
import cloud.tianai.captcha.template.slider.DefaultSliderCaptchaTemplate;
import cloud.tianai.captcha.template.slider.SliderCaptchaTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;

@Order
@Configuration
@EnableConfigurationProperties(value={SliderCaptchaProperties.class})
public class SliderCaptchaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SliderCaptchaTemplate sliderCaptchaTemplate(SliderCaptchaProperties prop) {
        DefaultSliderCaptchaTemplate template = new DefaultSliderCaptchaTemplate(prop.getTargetFormatName(), prop.getMatrixFormatName(), prop.getInitDefaultResource().booleanValue());
        return new CacheSliderCaptchaTemplate((SliderCaptchaTemplate)template, prop.getCacheSize().intValue());
    }

    @Bean
    @ConditionalOnClass(value={StringRedisTemplate.class})
    @ConditionalOnMissingBean
    public SliderCaptchaApplication redis(StringRedisTemplate redisTemplate, SliderCaptchaTemplate template, SliderCaptchaProperties properties) {
        return new RedisCacheSliderCaptchaApplication(redisTemplate, template, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.data.redis.core.StringRedisTemplate"})
    public SliderCaptchaApplication local(SliderCaptchaTemplate template, SliderCaptchaProperties properties) {
        return new LocalCacheSliderCaptchaApplication(template, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public CaptchaInterceptor captchaInterceptor(SliderCaptchaApplication application) {
        return new CaptchaInterceptor(application);
    }

    @Bean
    @ConditionalOnMissingBean
    public CaptchaAdvisor captchaAdvisor(CaptchaInterceptor interceptor) {
        return new CaptchaAdvisor(interceptor);
    }
}

