/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.slider;

import cloud.tianai.captcha.slider.SliderCaptchaApplication;
import cloud.tianai.captcha.template.slider.SliderCaptchaInfo;
import cloud.tianai.captcha.template.slider.SliderCaptchaTemplate;
import cloud.tianai.captcha.util.Sequence;
import cloud.tianai.captcha.vo.CaptchaResponse;
import cloud.tianai.captcha.vo.SliderCaptchaVO;

public abstract class AbstractSliderCaptchaApplication
implements SliderCaptchaApplication {
    private SliderCaptchaTemplate template;
    private Sequence sequence = new Sequence();

    public AbstractSliderCaptchaApplication() {
        this.template = new SliderCaptchaTemplate();
    }

    @Override
    public CaptchaResponse<SliderCaptchaVO> generateSliderCaptcha() {
        SliderCaptchaInfo slideImageInfo = this.template.getSlideImageInfo();
        String id = this.generatorId();
        this.cacheVerification(id, slideImageInfo.getXPercent());
        SliderCaptchaVO verificationVO = new SliderCaptchaVO(slideImageInfo.getBackgroundImage(), slideImageInfo.getSliderImage());
        return CaptchaResponse.of(id, verificationVO);
    }

    @Override
    public CaptchaResponse<SliderCaptchaVO> generateSliderCaptchaForWebp() {
        SliderCaptchaInfo slideImageInfo = this.template.getSlideImageInfoForWebp();
        String id = this.generatorId();
        this.cacheVerification(id, slideImageInfo.getXPercent());
        SliderCaptchaVO verificationVO = new SliderCaptchaVO(slideImageInfo.getBackgroundImage(), slideImageInfo.getSliderImage());
        return CaptchaResponse.of(id, verificationVO);
    }

    @Override
    public boolean matching(String id, Float percentage) {
        Float cachePercentage = this.getPercentForCache(id);
        if (cachePercentage == null || cachePercentage.floatValue() < 0.0f) {
            return false;
        }
        return this.template.percentageContrast(percentage, cachePercentage);
    }

    private String generatorId() {
        return String.valueOf(this.sequence.nextId());
    }

    protected abstract Float getPercentForCache(String var1);

    protected abstract void cacheVerification(String var1, Float var2);
}

