/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.autoconfiguration;

import cloud.tianai.captcha.aop.CaptchaAdvisor;
import cloud.tianai.captcha.aop.CaptchaInterceptor;
import cloud.tianai.captcha.slider.LocalCacheSliderCaptchaApplication;
import cloud.tianai.captcha.slider.RedisCacheSliderCaptchaApplication;
import cloud.tianai.captcha.slider.SliderCaptchaApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;

@Order
@Configuration
@EnableConfigurationProperties(value={SliderCaptchaProperties.class})
public class SliderCaptchaAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={StringRedisTemplate.class})
    @ConditionalOnMissingBean
    public SliderCaptchaApplication redis(StringRedisTemplate redisTemplate, SliderCaptchaProperties properties) {
        return new RedisCacheSliderCaptchaApplication(redisTemplate, properties.getPrefix(), properties.getExpire());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.data.redis.core.StringRedisTemplate"})
    public SliderCaptchaApplication local(SliderCaptchaProperties properties) {
        return new LocalCacheSliderCaptchaApplication(properties.getExpire());
    }

    @Bean
    @ConditionalOnMissingBean
    public CaptchaInterceptor captchaInterceptor(SliderCaptchaApplication application) {
        return new CaptchaInterceptor(application);
    }

    @Bean
    @ConditionalOnMissingBean
    public CaptchaAdvisor captchaAdvisor(CaptchaInterceptor interceptor) {
        return new CaptchaAdvisor(interceptor);
    }

    @ConfigurationProperties(prefix="captcha.slider")
    public static class SliderCaptchaProperties {
        private String prefix = "captcha:slider";
        private long expire = 60000L;

        public String getPrefix() {
            return this.prefix;
        }

        public long getExpire() {
            return this.expire;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setExpire(long expire) {
            this.expire = expire;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SliderCaptchaProperties)) {
                return false;
            }
            SliderCaptchaProperties other = (SliderCaptchaProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            return this.getExpire() == other.getExpire();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SliderCaptchaProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            long $expire = this.getExpire();
            result = result * 59 + (int)($expire >>> 32 ^ $expire);
            return result;
        }

        public String toString() {
            return "SliderCaptchaAutoConfiguration.SliderCaptchaProperties(prefix=" + this.getPrefix() + ", expire=" + this.getExpire() + ")";
        }
    }
}

